/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** triangle.h
*/
#ifndef __TRIANGLE_H__
#define __TRIANGLE_H__

#include <classes.h>

class triangle : public nonsolid
{
protected:

	Vector3 edge1,edge2,edge3;
	Vector3 n1,n2,n3;
	int smooth;
	
public:
	triangle(base*p=0,const char *n="Untitled",double x1=1,double y1=0,double z1=0,double x2=0,double y2=1,double z2=0,double x3=0,double y3=0,double z3=1,int s=0,texture *t=0);
	triangle(base *p,const char *n,Vector3 &v1,Vector3 &v2,Vector3 &v3,texture *t);
	triangle(base *p,const char *n,Vector3&,Vector3&,Vector3&);
	triangle(base *p,const char *n,texture *t,Vector3&,Vector3&,Vector3&);
	triangle(base *p,triangle *tc);
	~triangle();

	int		setNormal(Vector3 v1,Vector3 v2, Vector3 v3, int s);
	int		setNormal(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, int s);

	virtual int	exportPOV(FILE* f,int,int,int);
	virtual int	save(media *,int);
	virtual int	load(media *,int,int );

	virtual int	addToParent(base*);
	virtual int	removeFromParent();

	virtual base	*copy(base*);

	virtual void	dumpNames(int,int);

	virtual int	draw(view *,Matrix44,int);
	virtual int	calculate(int);
};


#endif
