/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** lathe.h
*/
#ifndef lathe_inc
#define lathe_inc

#include <stdio.h>

#include <classes.h>

#include "spline.h"


class lathe : public csgobj
{
	class points
	{
	public:
		double x;
		double y;

	public:
		points() {x = 0;y = 0;};
		points(double a,double b) {x = a;y = b;};
	};

protected:
	SPLINE_TYPE	spline_type;
	int		number_of_points;
	list<points>	lpt; 

public:
	lathe(base *b=0,char *n="Untitled",SPLINE_TYPE = LINEAR);
	~lathe();

	void addPoint(double x, double y);
	void removePoint(double x, double y, double tol);
	void removePoints(double x1, double y1, double x2, double y2);

	virtual int addToParent(base *);
	virtual void dumpNames(int, int);	

	virtual int exportPOV(FILE *,int,int,int);
	virtual int load(FILE *, int);
	virtual int save(FILE *);
};

#endif
