/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normal.cpp
*/
#include "normal.h"
#include "normalmap.h"
#include "normallist.h"
#include "bumpmap.h"
#include "slopemap.h"

normal::normal(textureBase *p) :textureBase(NORMAL,p)
{
	#ifdef DEBUG
		printf("entering normal-Constructor\n");
	#endif
	
        usePattern=false;
	setSubItems(true);
	setName("Normal");
	setInfo("Normal");	

	addAddableItem(NORMAL,false);
	addAddableItem(NORMALLIST,true);
	addAddableItem(NORMALMAP,true);
	addAddableItem(BUMPMAP,true);
	addAddableItem(SLOPEMAP,true);
	addAddableItem(TRANSFORMATIONS,true);
	addAddableItem(TURBULENCEMODIFIER,true);
	addAddableItem(PATTERNMODIFIER,false);
	addAddableItem(WARP,true);

	#ifdef DEBUG
		printf("exiting normal-Constructor\n");
	#endif
}

void	normal::setActive(bool a,textureBase *tb)
{
int i;

	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}


	if ((tb->getType()==TURBULENCEMODIFIER)||
	     (tb->getType()==TRANSFORMATIONS)) {
			tb->setActive(a);
			return;
	}

	if (a==false) return;
	for (i=0;i<elements.length();i++) elements[i]->setActive(false);
	tb->setActive(true);
}




void normal::addElement(textureBase* what,textureBase* where)
{
	if (what==NULL) return;
	what->setParent(this);
	setActive(true,what);
	what->setParent(this);
	setActive(true,what);

	switch(what->getType()) {
		default:
			textureBase::addElement(what,where);
		break;
	}
		
}

bool normal::isEqual(textureBase *tb)
{
#ifdef DEBUG
	printf("Comparing Normals..\n");
#endif
	if (!tb) return false;
	if (textureBase::isEqual(tb)==false) return false;

#ifdef DEBUG
	printf("Compared Normals..found it !\n");
#endif
	return true;
}


void normal::add(textureBase *tb)
{
int t;
	if (!tb) return;
	t=tb->getType();
	if ( canAdd(tb)==true) {
		tb->setParent(this);	
		addElement( tb,NULL);
	}
}

normal::~normal()
{
}


patternmodifier *normal::getMapModifier()
{
	return &modifier;
}



int	normal::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m) return -1;
	setMedia(m);
	#ifdef DEBUG
		printf("loading normal\n");
	#endif

	do {
		m->read(&chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"BMPM",4) == 0) {
			bumpMap *bumMap=new bumpMap(this);
			bumMap->load(m,len);
			addElement(bumMap,NULL);
			read=true;
		}
		if(strncmp(chunk,"SLPM",4) == 0) {
			slopeMap *sMap=new slopeMap(this);
			sMap->load(m,len);
			addElement(sMap,NULL);
			read=true;
		}
		if(strncmp(chunk,"NRMM",4) == 0) {
			normalMap *nMap=new normalMap(this);
			nMap->load(m,len);
			elements.append((textureBase*)nMap);
			read=true;
		}
		if(strncmp(chunk,"NRLL",4) == 0) {
			normalList *nList=new normalList(this);
			nList->load(m,len);
			elements.append((textureBase*)nList);
			read=true;
		}
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *tr=new Transformations(this);
			tr->load(m,len);
			addElement(tr,NULL);
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);		
			read=true;
		}
		if(strncmp(chunk,"PATM",4) == 0) {
			modifier.load(m,len);
			read=true;
		}
		if(strncmp(chunk,"DATA",4) == 0) {
			m->read(&usePattern,sizeof(bool));			
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );

	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...
	#ifdef DEBUG
		printf("loaded normal\n");
	#endif
	return 0;
}

int	normal::save(media *m)
{
int i;
chunk ch;
	if(!m) return -1;

        #ifdef DEBUG
		printf("saving Normal\n");
	#endif

	setMedia(m);	

	writeChunk("NRML");

	textureBase::save(m);
	
	for (i=0;i<elements.length();i++) {
		elements[i]->save(m);
	}
        modifier.save(m);

	ch.setMedia(m);
	ch.writeChunk("DATA");
	       	m->write(&usePattern,sizeof(bool) );
	ch.writeChunkLen();

	writeChunkLen();

        #ifdef DEBUG
		printf("saved Normal\n");
	#endif

	return 0;
}

bool normal::isExportable()
{
	return true;
}

bool normal::getUsePattern()
{
	return usePattern;
}

void normal::setUsePattern(bool a)
{
	usePattern=a;
}

int	normal::exportPOV(FILE *fp,int tab,int tabsize,int a, bool as_map)
{
int i;
	if(fp == 0) return -1;
	///if (isExportable()==false) return -1;
	#ifdef DEBUG
		printf("exporting normal (POV) \n");
	#endif

	printTab(fp,tab);
	fprintf(fp,"normal //Name:%s \n",getName() );

	printTab(fp,tab);
	fprintf(fp,"{\n");

	


	if (usePattern) modifier.exportPOV(fp,tab+tabsize,tabsize,a,false);
	else {

		for (i=0;i<elements.length();i++) {
			if ((elements[i]->active()==true)&&(elements[i]->getType()!=PATTERNMODIFIER)) {
				elements[i]->exportPOV(fp,tab+tabsize,tabsize,a,false);
			}
		}
	}

	printTab(fp,tab);
	fprintf(fp,"}\n");
	
	#ifdef DEBUG
		printf("exported normal (POV)\n");
	#endif
	return 0;
}

