/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentEntry.cpp
*/
#include "pigmententry.h"

/* XPM */
const char*pigmentEntryfolder[]={
"15 13 10 1",
"h c #a0a0a0",
"f c #00ff00",
"d c #000000",
"b c #ffff00",
"g c #0000ff",
"# c #999999",
". c None",
"a c #cccccc",
"c c #ffffff",
"e c #ff0000",
"..#####........",
".#ababa#.......",
"#abababa######.",
"#cccccccccccc#d",
"#cbeeebabfffb#d",
"#ceeeeebfffff#d",
"#ceeeeecfffff#d",
"#ceeeecccffff#d",
"#cbeecccccffb#d",
"#cabaggcggaba#d",
"#cbabgggggbab#d",
"#hhhhhhhhhhhh#d",
".dddddddddddddd"};

pigmentEntry::pigmentEntry(textureBase *p) :textureBase(PIGMENTENTRY,p)
{

	setName("Pigment-Entry");
        setInfo("Pigment-Entry");
	setSubItems(true);	

	addAddableItem(COLOR,true);
	addAddableItem(COLORLIST,true);
	addAddableItem(COLORMAP,true);
	addAddableItem(IMAGEMAP,true);
	addAddableItem(PIGMENT,true);
	addAddableItem(PIGMENTLIST,true);
	addAddableItem(PIGMENTMAP,true);
	addAddableItem(TRANSFORMATIONS,true);
	addAddableItem(TURBULENCEMODIFIER,true);

}


const char **pigmentEntry::getXPM()
{
	return pigmentEntryfolder;
}

void	pigmentEntry::setRange(double x)
{
	range=x;
}

double	pigmentEntry::getRange()
{
	return range;
}

void	pigmentEntry::setActive(bool a,textureBase *tb)
{
int i;

	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}

	if ((tb->getType()==TURBULENCEMODIFIER)||
	     (tb->getType()==TRANSFORMATIONS)) {
			tb->setActive(a);
			return;
	}

	if (a==false) return;
	for (i=0;i<elements.length();i++) elements[i]->setActive(false);
	tb->setActive(true);
}

void pigmentEntry::addElement(textureBase* what,textureBase* where)
{

	if (what==NULL) return;
	what->setParent(this);
	setActive(true,what);
	switch(what->getType()) {
	case PIGMENTENTRY:
	{
		color *c=new color(this);
		c->add(what);
		elements.append(c);
	}
	break;
	default:
		textureBase::addElement(what,where);
	break;
	}
#ifdef DEBUG
	printf("Adding Pigment-Element (l=%d)\n",elements.length());
#endif
	
}

void pigmentEntry::setQuickColor(color *c)
{
	if (quickcolor) delete quickcolor;
	quickcolor=c;
}

color *pigmentEntry::getQuickColor(textureBase *tb)
{

	return quickcolor;
}

pigmentEntry::~pigmentEntry()
{
}

void pigmentEntry::add(textureBase *tb)
{
	if (!tb) return
	tb->setParent(this);	
	addElement( tb,NULL);
}

bool pigmentEntry::isEqual(textureBase *tb)
{
#ifdef DEBUG
	printf("Comparing Pigment-entries..\n");
#endif
	if (!tb) return false;
	if (textureBase::isEqual(tb)==false) return false;

#ifdef DEBUG
	printf("Compared Pigment-entries..found it !\n");
#endif
	return true;

}


int	pigmentEntry::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m) return -1;
	setMedia(m);
#ifdef DEBUG
	printf("loading pigmentEntry\n");
#endif

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"COLR",4) == 0) {
			color *col=new color(this);
			col->load(m,len);
			addElement(col,NULL);
			read=true;
		}
		if(strncmp(chunk,"COLL",4) == 0) {
			colorList *colList=new colorList(this);
			colList->load(m,len);
			addElement(colList,NULL);
			read=true;
		}
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *trans=new Transformations(this);
			trans->load(m,len);
			addElement(trans,NULL);
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);
			read=true;
		}
		if(strncmp(chunk,"COLM",4) == 0) {
			colorMap *colMap=new colorMap(this);
			colMap->load(m,len);
			addElement(colMap,NULL);
			read=true;

		}
		if(strncmp(chunk,"IMGM",4) == 0) {
			imageMap *imgMap=new imageMap(this);
			imgMap->load(m,len);
			addElement(imgMap,NULL);
			read=true;
		}
		if(strncmp(chunk,"PIGM",4) == 0) {
			pigmentMap *pigMap=new pigmentMap(this);
			pigMap->load(m,len);
			addElement(pigMap,NULL);			
			read=true;
		}
		if(strncmp(chunk,"PIGL",4) == 0) {
			pigmentList *pigList=new pigmentList(this);
			pigList->load(m,len);
			addElement(pigList,NULL);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );

	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...  c
#ifdef DEBUG
	printf("loaded pigmentEntry\n");
#endif
	return 0;
}

int	pigmentEntry::save(media *m)
{

int i;

	if(!m) return -1;

	setMedia(m);
#ifdef DEBUG
	printf("saving pigmentEntry\n");
#endif
	writeChunk("PGME");

	textureBase::save(m);

	for (i=0;i<elements.length();i++) {
		elements[i]->save(m);
	}


	writeChunkLen();

#ifdef DEBUG
	printf("pigmentEntry saved\n");
#endif
	return 0;
}

int	pigmentEntry::exportPOV(FILE *fp,int tab,int tabsize,int a, bool as_map)
{
int i;

	#ifdef DEBUG
		printf("Exporting Pigment-Entry (POV)\n");
	#endif

	if(fp == 0)
		return -1;

	printTab(fp,tab);
	fprintf(fp,"[ %f    //%s  (Pigment-Entry)\n",getRange(),getName() );

	for (i=0;i<elements.length();i++) {
		if (elements[i]->active()==true) {
		elements[i]->exportPOV(fp,tab+tabsize,tabsize,a,as_map);
		}
	}

	printTab(fp,tab);
        fprintf(fp,"]\n");

	#ifdef DEBUG
		printf("Exported Pigment-Entry (POV)\n");
	#endif

	return 0;
}

