/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentlist.cpp
*/
#include "pigmentlist.h"

#include <misc.h>


static char	fnname[pigmentList::NFunctions][20] =
		{
		"brick",
		"checker",
		"hexagon"
		};



pigmentList::pigmentList(textureBase *p):textureBase(PIGMENTLIST,p)
{

	fn=Checker;

	setName("Pigmentlist");
	setInfo("Pigmentlist");
	setSubItems(true);

	addAddableItem(PIGMENT,true);
	addAddableItem(TURBULENCEMODIFIER,true);
	addAddableItem(TRANSFORMATIONS,true);
}

void	pigmentList::setActive(bool a,textureBase *tb)
{
	if (tb==NULL) {textureBase::setActive(a);return;}
	if (tb->getType()==COLORLIST) textureBase::setActive(a);
	else tb->setActive(a);
}

void pigmentList::addElement(textureBase* what,textureBase* where)
{
        if(!what) return;
	what->setParent(this);
	what->setActive(true);

	textureBase::addElement(what,where);

	updateInfo();
}



bool pigmentList::isEqual(textureBase *tb)
{

#ifdef DEBUG
	printf("Comparing Pigmentlist...\n");
#endif
	if (textureBase::isEqual(tb)==false) return false;
	if ( ((pigmentList*)tb)->getPigmentListFunction()!=fn) return false;

#ifdef DEBUG
	printf("Comparing Pigmentlist...found !\n");
#endif
	return true;
}

pigmentList::~pigmentList()
{
}

void pigmentList::updateInfo()
{
char *buffer=(char *)malloc(512);
	sprintf(buffer,"Pattern:%s",getPigmentListFunctionName());
	setInfo(buffer);
	free(buffer);
}

void pigmentList::setPigmentListFunction(FUNCTION f)
{
	fn=f;
	updateInfo();
}

int pigmentList::getPigmentListFunction()
{
	return fn;
}

char *pigmentList::getPigmentListFunctionName()
{
	return fnname[fn];
}

char *pigmentList::getPigmentListFunctionNameList(int n)
{
	return fnname[n];
}

int	pigmentList::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)	return -1;
	
	#ifdef DEBUG
		printf("loading PigmentList\n");
	#endif

	setMedia(m);

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"PLFN",4) == 0) {
			m->read(&fn,4);
			read=true;
		}
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *trans=new Transformations(this);
			trans->load(m,len);
			addElement(trans,NULL);
			read=true;
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			addElement(turb,NULL);
			read=true;
		}
		if(strncmp(chunk,"PGMT",4) == 0) {
			pigment *pig=new pigment(this);
			pig->load(m,len);
			addElement(pig,NULL);			
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}

		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET);

	#ifdef DEBUG
		printf("PigmentList loaded\n");
	#endif

	updateInfo();
	return 0;
}

void	pigmentList::add(textureBase *tb)
{
	if (tb==NULL) return;
	if (canAdd(tb)==false) return;
	addElement(tb,NULL);

	updateInfo();
}


int	pigmentList::save(media *m)
{
int i;
chunk ch;
	if(!m) return -1;
	#ifdef DEBUG
		printf("saving PigmentList\n");
	#endif
	setMedia(m);

	writeChunk("PIGL");

	textureBase::save(m);
        ch.setMedia(m);
	ch.writeChunk("PLFN");
		m->write(&fn,4);
	ch.writeChunkLen();

	for (i=0;i<elements.length();i++) {
		elements[i]->save(m);
	}

	writeChunkLen();

	#ifdef DEBUG
		printf("PigmentList saved\n");
	#endif
	return 0;
}

int pigmentList::exportPOV(FILE *fp,int tab,int tabsize,int a, bool dummy)
{
int i;

	if(fp == 0)
		return -1;
	#ifdef DEBUG
		printf("exporting PigmentList (POV)\n");
	#endif
	
	printTab(fp,tab);
	fprintf(fp,"%s  //%s (Pigmentlist)\n",getPigmentListFunctionName(),getName() );

	for (i=0;i<elements.length();i++) {
		if ((elements[i]->active()==true)&&(elements[i]->getType()!=TURBULENCEMODIFIER)&&(elements[i]->getType()!=TRANSFORMATIONS)) {
			elements[i]->exportPOV(fp,tab+tabsize,tabsize,a,false);                	
		}
	}

	textureBase::exportPOV(fp,tab,tabsize,a,dummy);
	
	#ifdef DEBUG
		printf("PigmentList exported (POV)\n");
	#endif

	return 0;
}
