/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** repeatwarp.cpp
*/
#include "repeatwarp.h"

repeatWarp::repeatWarp(textureBase *p):textureBase(REPEATWARP,p)
{
	setName("Repeat-Warp");
	setInfo("Repeat-Warp");
	setSubItems(false);

	flip=Vector3(0,0,0);
	offset=Vector3(0,0,0);
	dir=0;
	r_dir=0.0;
	
}

repeatWarp::~repeatWarp()
{
}

void	repeatWarp::setFlip(Vector3 x)
{
	flip=x;
	
}

Vector3	repeatWarp::getFlip()
{
	return flip;
}
	
void	repeatWarp::setOffset(Vector3 x)
{
	offset=x;
}

Vector3	repeatWarp::getOffset()
{
	return offset;
}

int	repeatWarp::getDirection()
{
	return dir;
}

void	repeatWarp::setDirection(int x)
{
	dir=x;
}

double	repeatWarp::getDirectionLength()
{
	return r_dir;
}

void	repeatWarp::setDirectionLength(double x)
{
	r_dir=x;
}

int	repeatWarp::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	#ifdef DEBUG
		printf("Loading Warp\n");
	#endif

	if(!m) return -1;
	setMedia(m);	
	

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if(strncmp(chunk,"DATA",4) == 0) {
			flip=readVector();
			offset=readVector();
			m->read(&dir,sizeof(int) );
			m->read(&r_dir,sizeof(double) );

		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...
	#ifdef DEBUG
		printf("repeatWarp loaded\n");
	#endif
	//updateInfo();
	return 0;
}



int repeatWarp::save(media *m)
{
chunk ch;
	if(!m)	return -1;
	#ifdef DEBUG
		printf("saving repeatWarp\n");
	#endif

	setMedia(m);

	writeChunk("WRPR");

	textureBase::save(m);
	
  	ch.setMedia(m);
	ch.writeChunk("DATA");

	writeVector(flip);
	writeVector(offset);
	m->write(&dir,sizeof(int) );
	m->write(&r_dir,sizeof(double) );
	
	
	ch.writeChunkLen();

	writeChunkLen();

	#ifdef DEBUG
		printf("repeatWarp saved\n");
	#endif
	return 0;
}

int repeatWarp::exportPOV(FILE *fp,int tab,int tabsize, int anim,bool dummy)
{
	if(!fp) return -1;
	#ifdef DEBUG
		printf("exporting repeatWarp (POV)\n");
	#endif

	if (dir!=0) {
		printTab(fp,tab);
		fprintf(fp,"repeat %g*",r_dir);
		if (dir==1) fprintf(fp,"x\n");
		if (dir==2) fprintf(fp,"y\n");
		if (dir==3) fprintf(fp,"z\n");
	        if ((flip[0]!=0)&&(flip[1]!=0)||(flip[2]!=0)) {
			printTab(fp,tab);
			fprintf(fp,"flip <%g,%g,%g>\n",flip[0],flip[1],flip[2]);
		}
	        if ((offset[0]!=0)&&(offset[1]!=0)||(offset[2]!=0)) {
			printTab(fp,tab);
			fprintf(fp,"offset <%g,%g,%g>\n",offset[0],offset[1],offset[2]);
		}
	}

	textureBase::exportPOV(fp,tab+tabsize,tabsize,anim,dummy);

	#ifdef DEBUG
		printf("repeatWarp exported (POV) saved\n");
	#endif
	return 0;
}


