/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** misc.h
*/

#ifndef __MISC_H__
#define __MISC_H__

//
// debug stuff
//

#ifdef DEBUG
#define dbcall(a)	printf("%s %i call: %s\n",__FILE__,__LINE__,#a); (a)
#else
#define dbcall(a)	(a)
#endif

#ifdef DEBUG
#define dbeval(a)	printf("%s %i eval: %s = %i\n",__FILE__,__LINE__,#a,a)
#else
#define dbeval(a)	{}
#endif

void	statmem();
void	reportmem();

#ifdef QTMEMDEBUG
#undef MEMDEBUG
#endif

#ifdef MEMDEBUG
void	dbfree(void *,const char*,int);
void	*dbmalloc(int,const char*,int);
void	*dbrealloc(void*,int,const char*,int);
char	*dbstrdup(const char*,const char*,int);


#define mark()		dbmark(__FILE__,__LINE__)
//#define mark(a)		dbmark(__FILE__,__LINE__,a)
#define free(a)		dbfree(a,__FILE__,__LINE__)
#define realloc(a,b)	dbrealloc(a,b,__FILE__,__LINE__)
#define malloc(a)	dbmalloc(a,__FILE__,__LINE__)
#define strdup(a)	dbstrdup(a,__FILE__,__LINE__)

#include <new.h>

void	*operator new(size_t s);
void	*operator new(size_t s,const char *file,int line);
void	*operator new(size_t s,const char *file,int line,const char *ex);

void	*operator new [] (size_t s);
void	*operator new [] (size_t s,const char *file,int line);
void	*operator new [] (size_t s,const char *file,int line,const char *ex);

void	operator delete(void *vp);
void	operator delete(void *vp,const char *file,int line);
void	operator delete [] (void *vp);
void	operator delete [] (void *vp,const char *file,int line);

#define new		new (__FILE__,__LINE__)
//#define delete		delete (__FILE__,__LINE__)


#endif

#ifdef DEBUG
#define dbhere()	printf("%s %i\n",__FILE__,__LINE__);
#else
#define dbhere()	{}
#endif

#define EXAMINE(a)	printf("class %s has size of %i bytes\n",#a,sizeof(a))

#define MIN(a,b)	((a)<(b)?(a):(b))
#define MAX(a,b)	((a)>(b)?(a):(b))

#define MIN3(a,b,c)	(MIN(a,MIN(b,c)))
#define MAX3(a,b,c)	(MAX(a,MAX(b,c)))

#ifndef PI
#define PI		3.1415926536
#endif

#ifndef FALSE
#define FALSE		0
#endif

#ifndef TRUE
#define TRUE		!FALSE
#endif


#define printTab(a,b)	{ int i; for(i = 0;i < (b);i++) fprintf((a)," ");}

#endif


