/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** dialogs.h
*/
#ifndef __DIALOG_H__
#define __DIALOG_H__

#include <anim.h>
#include <objects.h>

#include "../texture/previewwidget.h"
#include "../misc/image.h"
#include "../widgets/getfilewidget.h"
#include "../misc/preferences.h"

#include <qdialog.h>
#include <qlineedit.h> 
#include <qlabel.h> 
#include <qtabdialog.h>
#include <qpushbutton.h>
#include <qmultilinedit.h>
#include <qcombo.h>
#include <qcheckbox.h>
#include <qcolor.h>
#include <qlistbox.h>
#include <qmultilinedit.h>
#include <qgroupbox.h>

#include <kcolorbtn.h> 
//#include <kcombo.h>
#include <misc.h>
#include <texture.h>



class	NameDialog : public QDialog
{
Q_OBJECT

protected:
	QPushButton	*ok,*cancel;
	QLineEdit	*line;

public:
	NameDialog(QWidget *parent,const char *name);
	~NameDialog();

	QString		getName();
	void		setName(QString);

};

class	EarDialog : public QDialog
{
Q_OBJECT

protected:
	QPushButton	*ok,*cancel;
	QLineEdit	*line;

public:
	EarDialog(QWidget *parent,const char *name);
	~EarDialog();

	unsigned char	getChannel();
	void		setChannel(unsigned char);

};

class	InfoDialog : public QDialog
{
Q_OBJECT

protected:
	QPushButton	*ok;
	QLabel	*label;

public:
	InfoDialog(const char *);
	~InfoDialog();
};

class	CameraDialog : public QDialog
{
Q_OBJECT

protected:
	QPushButton	*ok,*cancel;
	QComboBox	*viewselect;

public:
	CameraDialog(QWidget *parent,const char *name);
	~CameraDialog();

	QString		getView();
	void		setViewList(QStrList);

};

class	BlobDialog : public QDialog
{
Q_OBJECT

protected:
	QPushButton	*ok,*cancel;
	QLineEdit	*line;
	QLabel		*label;

public:
	BlobDialog(QWidget *parent,const char *name);
	~BlobDialog();

	double		thresholdValue();
	void		setThresholdValue(double);

};


class	TextDialog : public QDialog
{
Q_OBJECT

protected:
	QPushButton	*ok,*cancel;
	QLineEdit	*wcontext,*wthickness,*wxoffset,*wyoffset;
	QLabel		*lcontext,*lthickness,*loffset;
/*
	QLineEdit	*wfontname;
	QLabel		*lfontname;
*/
	GetFileWidget	*wfontname;

public:
	TextDialog(QWidget *parent,const char *name);
	~TextDialog();

	void	save(QString &context,QString &fontname,double &thickness,Vector2 &offset);
	void	load(QString context,QString fontname,double thickness,Vector2 offset);
};

class	HeightFieldDialog : public QDialog
{
Q_OBJECT
protected:
	QPushButton	*ok,*cancel;
	QLineEdit	*wwaterlevel;
	GetFileWidget	*wfilename;
	QLabel		*lwaterlevel;
   	QLabel		*lfilename;
   	QCheckBox	*csmooth;

public:
	HeightFieldDialog(QWidget *parent,const char *name);
	~HeightFieldDialog();

	void	save(double &waterlevel,QString &filename,bool &smooth);
	void	load(double waterlevel,QString filename,bool smooth);
};

class	LightPointDialog : public QDialog
{
Q_OBJECT
protected:
	QPushButton	*ok,*cancel;
	QLineEdit	*wfadepower,*wfadedistance;
	QLabel		*lfadepower,*lfadedistance,*lcolor;
	KColorButton	*wcolor;

public:
	LightPointDialog(QWidget *parent,const char *name);
	~LightPointDialog();

	void	save(double *fadepower,double *fadedistance,Vector3 &color);
	void	load(double fadepower,double fadedistance,Vector3 color);
};

class	SpotLightDialog : public QDialog
{
Q_OBJECT
protected:
	QPushButton	*ok,*cancel;
	QLineEdit	*wfadepower,*wfadedistance;
	QLineEdit	*wradius,*wfalloff,*wtightness;
	QCheckBox	*cmattenuation,*cminteraction;
	QLabel		*lfadepower,*lfadedistance,*lcolor;
	QLabel		*lradius,*lfalloff,*ltightness;
	QLabel		*lmattenuation,*lminteraction;
	KColorButton	*wcolor;

public:
	SpotLightDialog(QWidget *parent,const char *name);
	~SpotLightDialog();

	void	save(double &radius,double &falloff,double &tightness,double &fadepower,double &fadedistance,Vector3 &color,bool &mi,bool &ma);
	void	load(double radius,double falloff,double tightness,double fadepower,double fadedistance,Vector3 color,bool mi,bool ma);
};

class AnimDialog : public QDialog
{
Q_OBJECT

protected:
	QPushButton	*ok,*add,*del;
	QMultiLineEdit	*mle;
	QComboBox	*fname;

	anim		*_anim;

	QString		oldstr;

public:
	AnimDialog(QWidget *parent,const char *name,anim *);
	~AnimDialog();

protected slots:
	void	addScript();
	void	delScript();
	void	selectScript(const char *);

	void	saveText();

private:
	void	layout();
	void	paintEvent(QPaintEvent*);
};


class ScriptDialog : public QDialog
{
Q_OBJECT

protected:
	QPushButton	*ok,*cancel;
	QMultiLineEdit	*mle;

	script		*scriptobj;

	QString		oldstr;

public:
	ScriptDialog(QWidget *parent,const char *name,script *);
	~ScriptDialog();

	void	saveText();

private:
	void	layout();
	void	paintEvent(QPaintEvent*);
};


class WorldDialog : public QDialog
{
Q_OBJECT

protected:
	QPushButton	*ok,*cancel;
	QLineEdit	*lex,*ley,*lez;
	QLabel		*allabel,*bgc_label;
	KColorButton	*backg_color;
	Vector3		ambient_light;

public:
	WorldDialog(QWidget *parent,const char *name);
	~WorldDialog();

	void	save(Vector3 &v,Vector3 &v);
	void	load(Vector3 v,Vector3 v);
};




#endif

