/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** viewwin.h
*/
#ifndef __VIEWWIN_H__
#define __VIEWWIN_H__

#include "viewwidget.h"

#include "version.h"

#include <ktmainwindow.h>
#include <ktoolbar.h>

#define MPopupMenu	QPopupMenu

class TextureView;

class ViewWin : public KTMainWindow
{
	Q_OBJECT
protected:
	
	ViewWidget		*viewwidget;

	KToolBar		*tbview,*tbtxtview,*mainbar;
	KStatusBar		*stbar;

	int			tb[10];

	int			changed;
 	char			*projectname;

public:
	ViewWin(QWidget *parent,char *name = 0);
	~ViewWin();

	virtual QSize	sizeHint() const
	{
		QSize	qs(-1,-1);
		
		return qs;
	};
	
	void	paintEvent(QPaintEvent*);
	void	show();

private:
	void	createWidgets(QWidget *);
	void	createWindowTitle();
	void	createStatusBar(QString);
	void	createToolBar();

public slots:
	// Toolbar
	void	setViewMode(int);
	void	savePicture();

	// Other slots
//	void	exportPOV(const char*);
//	void	exportPOVanim(const char*);
	void	resizedView(int,int);
	void	displayMessage(QString);
	void	autoSavePicture();
	void	setProjectName(const char*);
 	void	setViewName();
 	void	setViewObject(base *);
 	void	setViewSize(int w,int h);
 	void	destroy();

signals:
	void	viewMode(int);
	void	projectionMode(int);
	void	axeMode(int);
	void	render(int);
	void	destroyed();
	void	deleteMe(ViewWin*);
};

#endif

