/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** imageconverter.cpp
*/

#include "imconv.h"
#include "image.h"
#include "preferences.h"
#include <qimageio.h>

imConv::imConv() : imageConverter()
{
	name = 0;
	extension = 0;
}

const char *imConv::getType(const char *file)
{
#if (USE_QIMAGEIO == 1)
	return QImageIO::imageFormat(file);
#else
	if(extension)
	{
		free(extension);
		extension = 0;
	}
	if(file && strrchr(file,'.'))
		extension = strdup(strrchr(file,'.') + 1);
	
        return "???";
#endif
}

char *imConv::getExtension()
{
	return extension;
}

char *imConv::convert(char *sourcefile,int w, int h)
{
#if (USE_QIMAGEIO == 1)
	Image		*img = 0;
	char		*dat = 0;
	int		l;
	Preferences	prefs;
	FILE		*file;
	char		buffer[4096];

	if (!sourcefile) return 0;

	img = new Image(0,false);
	if(!img) return 0;

	img->load(sourcefile);
	dat = img->getImage(&l,w,h);
	if(!dat) return 0;

	extension = img->getExtension();

	sprintf(buffer,"%s/%i.%s",(char*)prefs.getTempPath(),rand(),extension);
	name = strdup(buffer);

#ifdef DEBUG
	printf("New Image-filename:%s   exten.:%s\n",name,extension);
#endif

	file=fopen(name,"w");
	if(file)
	{
		fwrite(dat,1,l,file);
		fclose(file);
	}
	else
	{
		free(dat);
		return 0;
	}

	free(dat);

	return name;
#else
/*
	if(strrchr(sourcefile,'.'))
		extension = strdup(strrchr(sourcefile,'.') + 1);
	
	return sourcefile;
*/
	return 0;
#endif
}

imConv::~imConv()
{
	if (name) free(name);
	if (extension) free(extension);
}

