/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** preferences.cpp
*/
#include "preferences.h"

#include <kapp.h>

#include <stdlib.h>

#include <misc.h>
#include <evaluate.h>

Preferences::Preferences()
{
	QColor			backcolor, drawcolor, selcolor, boxcolor;
	QColor			gridcolor, blobcolor;
	QColor			xaxiscolor,yaxiscolor,zaxiscolor;
	QColor			letterxcolor,letterycolor,letterzcolor;
	QString			datapath;
	extern KApplication	*k4deapp;
	int			i,n,check;
        QString			f,s;

	backcolor = QColor(200,200,200);
	drawcolor = QColor(0,0,0);
	selcolor = QColor(255,255,255);
	boxcolor = QColor(200,200,255);
	gridcolor = QColor(100,100,200);
	blobcolor = QColor(224,128,128);	
	xaxiscolor = QColor(255,0,0);
	yaxiscolor = QColor(0,255,0);
	zaxiscolor = QColor(0,0,255);
	letterxcolor = QColor(128,0,0);
	letterycolor = QColor(0,128,0);
	letterzcolor = QColor(0,0,128);
	

	cfg = new KSimpleConfig(getPath("~/.k4de/k4derc"));
	if(cfg == 0)
	{
		datapath = k4deapp->kde_datadir() + "/k4de/";
		cfg = new KSimpleConfig(getPath(datapath + "k4derc"));		
	}

	cfg->setGroup("Paths");
	setTexturePath(cfg->readEntry("TexturePath","~/.k4de/texture"));
	setTempPath(cfg->readEntry("TempPath","/tmp"));
	setImagePath(cfg->readEntry("ImagePath","~/.k4de/images"));
	setBumpMapPath(cfg->readEntry("BumpMapPath","~/.k4de/texture/bumpmap"));
	setAnimationPath(cfg->readEntry("AnimationPath","~/.k4de/animations"));
	setImageMapPath(cfg->readEntry("ImageMapPath","~/.k4de/texture/imagemap"));
	setDataPath(cfg->readEntry("DataPath","~/.k4de/3dds"));
	setFontPath(cfg->readEntry("FontPath","~/.k4de/font"));
	setHeightfieldPath(cfg->readEntry("HeightfieldPath","~/.k4de/heightfield"));

	cfg->setGroup("WireFrameEditor");
	setGridColor( cfg->readColorEntry("GridColor",&gridcolor) );
	setXAxisColor( cfg->readColorEntry("XAxisColor",&xaxiscolor) );
	setYAxisColor( cfg->readColorEntry("YAxisColor",&yaxiscolor) );
	setZAxisColor( cfg->readColorEntry("ZAxisColor",&zaxiscolor) );
	setBackgroundColor( cfg->readColorEntry("BackgroundColor",&backcolor) );
	setLinesColor( cfg->readColorEntry("LinesColor",&drawcolor) );
	setSelectedLinesColor( cfg->readColorEntry("SelectedLinesColor",&selcolor) );
	setBlobColor( cfg->readColorEntry("BlobColor",&blobcolor) );
	setBoxColor(cfg->readColorEntry("BoxColor",&boxcolor) );
	setDrawAxes(cfg->readBoolEntry("DrawAxes",false) );	
	setLetterXColor( cfg->readColorEntry("LetterXColor",&letterxcolor) );
	setLetterYColor( cfg->readColorEntry("LetterYColor",&letterycolor) );
	setLetterZColor( cfg->readColorEntry("LetterZColor",&letterzcolor) );

	setGridLinesXY(cfg->readNumEntry("GridLinesXY",-1));
	setGridLinesXZ(cfg->readNumEntry("GridLinesXZ",10));
	setGridLinesZY(cfg->readNumEntry("GridLinesZY",-1));
	setGridPointsXY(cfg->readNumEntry("GridPointsXY",-1));
	setGridPointsXZ(cfg->readNumEntry("GridPointsXZ",-1));
	setGridPointsZY(cfg->readNumEntry("GridPointsZY",-1));
	setGridSpaceXY(cfg->readDoubleNumEntry("GridSpaceXY",1));
	setGridSpaceXZ(cfg->readDoubleNumEntry("GridSpaceXZ",1));
	setGridSpaceZY(cfg->readDoubleNumEntry("GridSpaceZY",1));
	setGridXY(cfg->readBoolEntry("GridXY",0));
	setGridXZ(cfg->readBoolEntry("GridXZ",1));
	setGridZY(cfg->readBoolEntry("GridZY",0));


	cfg->setGroup("Cluster");	

	setShowClusterStatistics(cfg->readBoolEntry("ShowStatistics",true) );

	clusterHosts.clear();

	n=cfg->readNumEntry("ClusterNum",0);

	for(i = 0;i <n;i++)
	{
		s.sprintf("ClusterHost%i",i);
		f = cfg->readEntry(s,"");
		if(f == "") continue;
		setClusterHost(f);
	}

	
	cfg->setGroup("Renderer");

	setRenderProgramParams(cfg->readEntry("RenderProgramParam1",""),cfg->readEntry("RenderProgramParam2",""),cfg->readEntry("RenderProgramParam3",""),cfg->readNumEntry("UseRenderProgramParameter",0));
	setRenderProgram(cfg->readEntry("RenderProgram","povray"));

	setRenderPreviewProgramParams(cfg->readEntry("RenderPreviewProgramParam1",""),cfg->readEntry("RenderPreviewProgramParam2",""),cfg->readEntry("RenderPreviewProgramParam3",""),cfg->readNumEntry("UseRenderPreviewProgramParameter",0));
	setRenderPreviewProgram(cfg->readEntry("RenderPreviewProgram","povray"));

	setRenderSmallPreviewProgramParams(cfg->readEntry("RenderSmallPreviewProgramParam1",""),cfg->readEntry("RenderSmallPreviewProgramParam2",""),cfg->readEntry("RenderSmallPreviewProgramParam3",""),cfg->readNumEntry("UseRenderSmallPreviewProgramParameter",0));
	setRenderSmallPreviewProgram(cfg->readEntry("RenderSmallPreviewProgram","povray"));
	
	//setRenderPreview(cfg->readNumEntry("RenderPreview"));
	//setPreviewSize(cfg->readNumEntry("PreviewSize"));

	cfg->setGroup("Monitor");

	setScreenSize(cfg->readNumEntry("ScreenWidth",270),cfg->readNumEntry("ScreenHeight",190));
	setResolution(cfg->readNumEntry("ResolutionWidth",800),cfg->readNumEntry("ResolutionHeight",600));


	cfg->setGroup("Dialogs");

	setMainWindowSize(cfg->readNumEntry("MainWindowWidth",700),cfg->readNumEntry("MainWindowHeight",500));
	setAnimEditorSize(cfg->readNumEntry("AnimEditorWidth",400),cfg->readNumEntry("AnimEditorHeight",300));
	
	cfg->setGroup("Textures");
	setDefaultTextureFile(cfg->readEntry("DefaultTextureFile",getTexturePath()+"/default"));

	cfg->setGroup("Menus");

    	setMaxNumRecentFiles((n = cfg->readNumEntry("MaxNumRecent",8)));	
	setCheckExistance((check = cfg->readNumEntry("CheckExistance",0)));

	recentfiles.clear();
	for(i = n;i >= 0;i--)
	{
		s.sprintf("RecentFile%i",i);
		f = cfg->readEntry(s,"");
		if(f == "") continue;

		setRecentFile(f);
	}
	
	
	cfg->setGroup("Tools");

	recursivlabels.clear();
	recursivfunctions.clear();

	i = cfg->readListEntry("RecursivTreeLabels",recursivlabels,'@');
	n = cfg->readListEntry("RecursivTreeFunctions",recursivfunctions,'@');
	
	num_recursiventries = i;
	
#ifdef DEBUG
	printf("labels (%i) and functions (%i)\n",i,n);
#endif
	if(i != n)
	{
#ifdef DEBUG
		printf("Error in configfile: entrydifference between labels (%i) and functions (%i)\n",i,n);
#endif
		num_recursiventries = MIN(i,n);
	}
		
		
	cfg->setGroup("Misc");
	setAutoSavePicture(cfg->readBoolEntry("AutoSavePicture",0));
	setTranslatePOV(cfg->readBoolEntry("TranslatePOV",0));
	
	delete cfg;
	cfg = 0;
}

Preferences::~Preferences()
{
	if(cfg != 0)
	{
		delete cfg;
	}
	// save();
}



void Preferences::setRenderPreview(int n)
{
	RenderPreview=n;
}

int	Preferences::getScreenWidth()
{
	return screen_width;
}

int	Preferences::getScreenHeight()
{
	return screen_height;
}

void	Preferences::setScreenSize(int w,int h)
{
	screen_width = w;
	screen_height = h;
}

int	Preferences::getResolutionWidth()
{
	return res_width;
}

int	Preferences::getResolutionHeight()
{
	return res_height;
}

void	Preferences::setResolution(int w,int h)
{
	res_width = w;
	res_height = h;
}

double	Preferences::getAspectRatio()
{
	double	sw,sh,rw,rh,pw,ph,ar;

	sw = getScreenWidth();
	sh = getScreenHeight();
	rw = getResolutionWidth();
	rh = getResolutionHeight();

	pw = sw / rw;
	ph = sh / rh;

	if(ph != 0)
		ar = pw / ph;
	else
		ar = 1;

	return ar;
}

int	Preferences::getMainWindowWidth()
{
	return mainwin_width;
}

int	Preferences::getMainWindowHeight()
{
	return mainwin_height;
}

void	Preferences::setMainWindowSize(int w,int h)
{
	mainwin_width = w;
	mainwin_height = h;
}

int	Preferences::getAnimEditorWidth()
{
	return animeditor_width;
}

int	Preferences::getAnimEditorHeight()
{
	return animeditor_height;
}

void	Preferences::setAnimEditorSize(int w,int h)
{
	animeditor_width = w;
	animeditor_height = h;
}

int Preferences::getRenderPreview()
{
	return RenderPreview;
}

void Preferences::setPreviewSize(int n)
{
	PreviewSize=n;
}

int Preferences::getPreviewSize()
{
	return PreviewSize;
}

void Preferences::setTexturePath(QString n)
{
	texturePath = n;
}

QString Preferences::getTexturePath()
{
	return texturePath;
}

void Preferences::setAnimationPath(QString n)
{
	animationPath = n;
}

QString Preferences::getAnimationPath()
{
	return animationPath;
}

void Preferences::setTempPath(QString n)
{
	tempPath = n;
}

QString Preferences::getTempPath()
{
	return tempPath;
}

void Preferences::setImagePath(QString n)
{
	imagePath = n;
}

QString Preferences::getImagePath()
{
	return imagePath;
}

void Preferences::setBumpMapPath(QString n)
{
	bumpMapPath = n;
}

QString Preferences::getBumpMapPath()
{
	return bumpMapPath;
}


void Preferences::setDataPath(QString n)
{
	dataPath = n;
}	

QString Preferences::getDataPath()
{
	return dataPath;
}

void Preferences::setFontPath(QString n)
{
	fontPath = n;
}	

QString Preferences::getFontPath()
{
	return fontPath;
}

void Preferences::setHeightfieldPath(QString n)
{
	heightfieldPath = n;
}	

QString Preferences::getHeightfieldPath()
{
	return heightfieldPath;
}

QString Preferences::getImageMapPath()
{
	return imageMapPath;
}

void Preferences::setImageMapPath(QString n)
{
	imageMapPath = n;
}

void Preferences::setBoxColor(QColor qc)
{
	BoxColor = qc;
}

QColor Preferences::getBoxColor()
{
	return BoxColor;
}

void Preferences::setGridColor(QColor qc)
{
	GridColor = qc;
}

QColor Preferences::getGridColor()
{
	return GridColor;
}

void Preferences::setXAxisColor(QColor qc)
{
	XAxisColor = qc;
}

QColor Preferences::getXAxisColor()
{
	return XAxisColor;
}

void Preferences::setYAxisColor(QColor qc)
{
	YAxisColor = qc;
}

QColor Preferences::getYAxisColor()
{
	return YAxisColor;
}

void Preferences::setZAxisColor(QColor qc)
{
	ZAxisColor = qc;
}

QColor Preferences::getZAxisColor()
{
	return ZAxisColor;
}

void Preferences::setBackgroundColor(QColor qc)
{
	BackgroundColor = qc;
}

QColor Preferences::getBackgroundColor()
{
	return BackgroundColor;
}

void Preferences::setLinesColor(QColor qc)
{
	LinesColor = qc;
}

QColor Preferences::getLinesColor()
{
	return LinesColor;
}

void Preferences::setSelectedLinesColor(QColor qc)
{
	SelectedLinesColor = qc;
}

QColor Preferences::getSelectedLinesColor()
{
	return SelectedLinesColor;
}

void Preferences::setLetterXColor(QColor qc)
{
	LetterXColor = qc;
}

QColor Preferences::getLetterXColor()
{
	return LetterXColor;
}

void Preferences::setLetterYColor(QColor qc)
{
	LetterYColor = qc;
}

QColor Preferences::getLetterYColor()
{
	return LetterYColor;
}

void Preferences::setLetterZColor(QColor qc)
{
	LetterZColor = qc;
}

QColor Preferences::getLetterZColor()
{
	return LetterZColor;
}

void Preferences::setBlobColor(QColor qc)
{
	BlobColor = qc;
}

QColor Preferences::getBlobColor()
{
	return BlobColor;
}

void Preferences::setDrawAxes(bool x)
{
	DrawAxes = x;
}

bool Preferences::getDrawAxes()
{
	return DrawAxes;
}

QString Preferences::getRenderProgram()
{
	return RenderProgram;
}

void Preferences::setRenderProgram(QString n)
{
	 RenderProgram = n;	
}

void Preferences::setRenderProgramParams(QString a, QString b, QString c, int n)
{
	RenderProgramParam1 = a;
	RenderProgramParam2 = b;
	RenderProgramParam3 = c;
	activeRenderProgramParam = n;
}

QString Preferences::getRenderProgramParam1()
{
	return RenderProgramParam1;
}
QString Preferences::getRenderProgramParam2()
{
	return RenderProgramParam2;
}
QString Preferences::getRenderProgramParam3()
{
	return RenderProgramParam3;
}

int Preferences::getActiveRenderProgramParam()
{
	return activeRenderProgramParam;
}

QString Preferences::getRenderSmallPreviewProgram()
{
	return RenderProgram;
}

void Preferences::setRenderSmallPreviewProgram(QString n)
{
	RenderSmallPreviewProgram = n;	
}

void Preferences::setRenderSmallPreviewProgramParams(QString a, QString b, QString c, int n)
{
	RenderSmallPreviewProgramParam1 = a;
	RenderSmallPreviewProgramParam2 = b;
	RenderSmallPreviewProgramParam3 = c;
	activeRenderSmallPreviewProgramParam = n;
}

QString Preferences::getRenderSmallPreviewProgramParam1()
{
	return RenderSmallPreviewProgramParam1;
}
QString Preferences::getRenderSmallPreviewProgramParam2()
{
	return RenderSmallPreviewProgramParam2;
}
QString Preferences::getRenderSmallPreviewProgramParam3()
{
	return RenderSmallPreviewProgramParam3;
}

int Preferences::getActiveRenderSmallPreviewProgramParam()
{
	return activeRenderProgramParam;
}

QString Preferences::getRenderPreviewProgram()
{
	return RenderPreviewProgram;
}

void Preferences::setRenderPreviewProgram(QString n)
{
	RenderPreviewProgram = n;	
}

void Preferences::setRenderPreviewProgramParams(QString a, QString b, QString c, int n)
{
	RenderPreviewProgramParam1 = a;
	RenderPreviewProgramParam2 = b;
	RenderPreviewProgramParam3 = c;
	activeRenderPreviewProgramParam = n;
}

QString Preferences::getRenderPreviewProgramParam1()
{
	return RenderPreviewProgramParam1;
}

QString Preferences::getRenderPreviewProgramParam2()
{
	return RenderPreviewProgramParam2;
}

QString Preferences::getRenderPreviewProgramParam3()
{
	return RenderPreviewProgramParam3;
}

int Preferences::getActiveRenderPreviewProgramParam()
{
	return activeRenderPreviewProgramParam;
}

void	Preferences::setGridLinesXY(int n)
{
	gridlines_xy = n;
}

int	Preferences::getGridLinesXY()
{
	return gridlines_xy;
}

void	Preferences::setGridLinesXZ(int n)
{
	gridlines_xz = n;
}

int	Preferences::getGridLinesXZ()
{
	return gridlines_xz;
}

void	Preferences::setGridLinesZY(int n)
{
	gridlines_zy = n;
}

int	Preferences::getGridLinesZY()
{
	return gridlines_zy;
}


void	Preferences::setGridPointsXY(int n)
{
	gridpoints_xy = n;
}

int	Preferences::getGridPointsXY()
{
	return gridpoints_xy;
}

void	Preferences::setGridPointsXZ(int n)
{
	gridpoints_xz = n;
}

int	Preferences::getGridPointsXZ()
{
	return gridpoints_xz;
}

void	Preferences::setGridPointsZY(int n)
{
	gridpoints_zy = n;
}

int	Preferences::getGridPointsZY()
{
	return gridpoints_zy;
}

void Preferences::setDefaultTextureFile(QString n)
{
	defaultTextureFile = n;
}

QString Preferences::getDefaultTextureFile()
{
	return defaultTextureFile;
}

void	Preferences::setGridSpaceXY(double n)
{
	gridspace_xy = n;
}

double	Preferences::getGridSpaceXY()
{
	return gridspace_xy;
}

void	Preferences::setGridSpaceXZ(double n)
{
	gridspace_xz = n;
}

double	Preferences::getGridSpaceXZ()
{
	return gridspace_xz;
}

void	Preferences::setGridSpaceZY(double n)
{
	gridspace_zy = n;
}

double	Preferences::getGridSpaceZY()
{
	return gridspace_zy;
}

void	Preferences::setGridXY(bool b)
{
	grid_xy = b;
}

bool	Preferences::getGridXY()
{
	return grid_xy;
}

void	Preferences::setGridXZ(bool b)
{
	grid_xz = b;
}

bool	Preferences::getGridXZ()
{
	return grid_xz;
}

void	Preferences::setGridZY(bool b)
{
	grid_zy = b;
}

bool	Preferences::getGridZY()
{
	return grid_zy;
}


int	Preferences::maxNumRecentFiles()
{
	return num_recentfiles;
}

void	Preferences::setMaxNumRecentFiles(int n)
{
	num_recentfiles = n;
}

int	Preferences::checkExistance()
{
	return check_existance;
}
	
void	Preferences::setCheckExistance(int n)
{
	check_existance = n;
}

int	Preferences::numRecentFiles()
{
	return recentfiles.count();
}

QString	Preferences::recentFile(int n)
{
	QString		f,s;

	if(n < 0 || n > numRecentFiles())
		return f;

	if(recentfiles.at(n) != 0)
		f = recentfiles.at(n);
				
	return f;
}
	
void	Preferences::setRecentFile(QString f)
{
	int		i;
	
	for(i = 0;i < numRecentFiles();i++)
	{
		if(recentfiles.at(i) == f)
			return;
	}
	
	recentfiles.insert(0,f);
}

void	Preferences::setShowClusterStatistics(bool s)
{
	showClusterStatistics=s;
}
bool	Preferences::getShowClusterStatistics()
{
	return showClusterStatistics;
}

int	Preferences::numClusterHosts()
{
	return clusterHosts.count();
}

QString	Preferences::recentClusterHost(int n)
{
	QString		f,s;

	if(n < 0 || n > numClusterHosts())
		return f;

	if(clusterHosts.at(n) != 0)
		f = clusterHosts.at(n);
				
	return f;

}
void	Preferences::setClusterHost(QString f)
{
	int		i;
	
	for(i = 0;i < numClusterHosts();i++)
	{
		if(clusterHosts.at(i) == f)
			return;
	}
	
	clusterHosts.insert(0,f);

}

void 	Preferences::deleteClusterHostList()
{
	clusterHosts.clear();
}

void	Preferences::setAutoSavePicture(bool b)
{
	autosaverendered = b;
}

bool	Preferences::getAutoSavePicture()
{
	return autosaverendered;
}

int	Preferences::getRecursivTreeNumEntries()
{
	return num_recursiventries;
}

QString	Preferences::getRecursivTreeLabel(int n)
{
	return recursivlabels.at(n);
}

QString	Preferences::getRecursivTreeFunction(int n)
{
	return recursivfunctions.at(n);
}

void	Preferences::setRecursivTree(QString label,QString function)
{
	int		i;
	QStrList	sll,slf;
	
	for(i = 0;i < num_recursiventries;i++)
	{
		if(getRecursivTreeLabel(i) != label)
		{
			sll.append(getRecursivTreeLabel(i));
			slf.append(getRecursivTreeFunction(i));
		}
	}
	sll.append(label);		
	slf.append(function);
	
	recursivlabels = sll;
	recursivfunctions = slf;
	
	num_recursiventries = MIN(recursivlabels.count(),recursivfunctions.count());
	
#ifdef DEBUG
	printf("%i  %i  %i\n",num_recursiventries,recursivlabels.count(),recursivfunctions.count());
#endif		
}

void	Preferences::deleteRecursivTree(QString label)
{
	int		i;
	QStrList	sll,slf;
	
	for(i = 0;i < num_recursiventries;i++)
	{
		if(getRecursivTreeLabel(i) != label)
		{
			sll.append(getRecursivTreeLabel(i));
			slf.append(getRecursivTreeFunction(i));
		}
	}
	
	recursivlabels = sll;
	recursivfunctions = slf;		
	
	num_recursiventries = MIN(recursivlabels.count(),recursivfunctions.count());		
}

void	Preferences::setTranslatePOV(bool b)
{
	translate_pov = b;
}

bool	Preferences::getTranslatePOV()
{
	return translate_pov;
}

void Preferences::save()
{
	int		i;
	QString		s;
	
	if(cfg == 0)
		cfg = new KSimpleConfig(getPath("~/.k4de/k4derc"));
	if(cfg != 0)
	{
		cfg->setGroup("Paths");
		cfg->writeEntry("TexturePath",getTexturePath());
		cfg->writeEntry("TempPath",getTempPath());
		cfg->writeEntry("ImagePath",getImagePath());
		cfg->writeEntry("BumpMapPath",getBumpMapPath());
		cfg->writeEntry("AnimationPath",getAnimationPath());
		cfg->writeEntry("ImageMapPath",getImageMapPath());
		cfg->writeEntry("DataPath",getDataPath());
		cfg->writeEntry("FontPath",getFontPath());
		cfg->writeEntry("HeightfieldPath",getHeightfieldPath());

		cfg->setGroup("WireFrameEditor");
		
		cfg->writeEntry("GridColor",GridColor);
		cfg->writeEntry("XAxisColor",XAxisColor);
		cfg->writeEntry("YAxisColor",YAxisColor);
		cfg->writeEntry("ZAxisColor",ZAxisColor);
		cfg->writeEntry("BackgroundColor",BackgroundColor);
		cfg->writeEntry("LinesColor",LinesColor);
		cfg->writeEntry("SelectedLinesColor",SelectedLinesColor);
		cfg->writeEntry("BlobColor",BlobColor);
		cfg->writeEntry("BoxColor",BoxColor);
		cfg->writeEntry("DrawAxes",DrawAxes);	
		cfg->writeEntry("LetterXColor",LetterXColor);
		cfg->writeEntry("LetterYColor",LetterYColor);
		cfg->writeEntry("LetterZColor",LetterZColor);
					
		cfg->writeEntry("GridLinesXY",getGridLinesXY());
		cfg->writeEntry("GridLinesXZ",getGridLinesXZ());
		cfg->writeEntry("GridLinesZY",getGridLinesZY());

		cfg->writeEntry("GridPointsXY",getGridPointsXY());
		cfg->writeEntry("GridPointsXZ",getGridPointsXZ());
		cfg->writeEntry("GridPointsZY",getGridPointsZY());

		cfg->writeEntry("GridSpaceXY",getGridSpaceXY());
		cfg->writeEntry("GridSpaceXZ",getGridSpaceXZ());
		cfg->writeEntry("GridSpaceZY",getGridSpaceZY());

		cfg->writeEntry("GridXY",getGridXY());
		cfg->writeEntry("GridXZ",getGridXZ());
		cfg->writeEntry("GridZY",getGridZY());

		cfg->setGroup("Renderer");
		cfg->writeEntry("RenderProgram",getRenderProgram());
		cfg->writeEntry("RenderProgramParam1",getRenderProgramParam1());
		cfg->writeEntry("RenderProgramParam2",getRenderProgramParam2());
		cfg->writeEntry("RenderProgramParam3",getRenderProgramParam3());
		cfg->writeEntry("UseRenderProgramParameter",getActiveRenderProgramParam());
					
		cfg->writeEntry("RenderPreviewProgram",getRenderPreviewProgram());
		cfg->writeEntry("RenderPreviewProgramParam1",getRenderPreviewProgramParam1());
		cfg->writeEntry("RenderPreviewProgramParam2",getRenderPreviewProgramParam2());
		cfg->writeEntry("RenderPreviewProgramParam3",getRenderPreviewProgramParam3());
		cfg->writeEntry("UseRenderPreviewProgramParameter",getActiveRenderPreviewProgramParam());
					
	
		cfg->writeEntry("RenderSmallPreviewProgram",getRenderSmallPreviewProgram());
		cfg->writeEntry("RenderSmallPreviewProgramParam1",getRenderSmallPreviewProgramParam1());
		cfg->writeEntry("RenderSmallPreviewProgramParam2",getRenderSmallPreviewProgramParam2());
		cfg->writeEntry("RenderSmallPreviewProgramParam3",getRenderSmallPreviewProgramParam3());
		cfg->writeEntry("UseRenderSmallPreviewProgramParameter",getActiveRenderSmallPreviewProgramParam());

		cfg->setGroup("Monitor");
		cfg->writeEntry("ScreenWidth",getScreenWidth());
		cfg->writeEntry("ScreenHeight",getScreenHeight());
		cfg->writeEntry("ResolutionWidth",getResolutionWidth());
		cfg->writeEntry("ResolutionHeight",getResolutionHeight());
	
		cfg->setGroup("Dialogs");
		cfg->writeEntry("MainWindowWidth",getMainWindowWidth());
		cfg->writeEntry("MainWindowHeight",getMainWindowHeight());
//		printf("I wrote (%i,%i)\n",getMainWindowWidth(),getMainWindowHeight());
		cfg->writeEntry("AnimEditorWidth",getAnimEditorWidth());
		cfg->writeEntry("AnimEditorHeight",getAnimEditorHeight());
		
		cfg->setGroup("Textures");
		cfg->writeEntry("DefaultTextureFile",getDefaultTextureFile());

		cfg->setGroup("Cluster");	

		cfg->writeEntry("ShowStatistics",getShowClusterStatistics() );
		cfg->writeEntry("ClusterNum",numClusterHosts());
		for(i = 0;i < numClusterHosts();i++)
		{
			s.sprintf("ClusterHost%i",i);
			cfg->writeEntry(s,clusterHosts.at(i));
		}

 		cfg->setGroup("Menus");
		cfg->writeEntry("MaxNumRecentFiles",maxNumRecentFiles());
		cfg->writeEntry("CheckExistance",checkExistance());

		for(i = 0;i < numRecentFiles();i++)
		{
			s.sprintf("RecentFile%i",i);
			cfg->writeEntry(s,recentfiles.at(i));
		}
		cfg->setGroup("Misc");
		cfg->writeEntry("AutoSavePicture",getAutoSavePicture());
		cfg->writeEntry("TranslatePOV",getTranslatePOV());
		
		
		cfg->setGroup("Tools");
		cfg->writeEntry("RecursivTreeLabels",recursivlabels,'@');
		cfg->writeEntry("RecursivTreeFunctions",recursivfunctions,'@');
		
		
		cfg->sync();
		
		delete cfg;
		cfg = 0;
	}
}

QString	Preferences::getPath(QString p)
{
	QString	home,path;

//	printf("HOME=%s\n",getenv("HOME"));

	if(p[0] == '~')
	{
		home = getenv("HOME");
		path = home + p.mid(1,p.length());
	}
	else if(p[0] != '/')
	{
		home = getenv("HOME");
		path = home + "/" + p;
	}
	else
		path = p;

	//printf("PATH=%s\n",path.data());

	return path;
}

QString	Preferences::povI18n(const char *t)
{
	QString		qstr;
	
	if(getTranslatePOV())
		qstr = i18n(t);
	else
		qstr = t;
		
	return qstr;
}





