/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colorentrywidget.h
*/
#ifndef __COLORENTRYWIDGET_H__
#define __COLORENTRYWIDGET_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qcheckbox.h>

#include "../../3d/textures/colorentry.h"
#include <qcolor.h>
#include "../widgets/spinbox.h"
#include "../widgets/percentwidget.h"
#include "texturebasewidget.h"
#include "texturewidgetbase.h"

class ColorEntryWidget : public TextureWidgetBase
{
Q_OBJECT
protected:
	colorEntry *co;
	SpinBox			*range;
	QColor qc;
	KColorButton		*colorbt;
	PercentWidget		*transp,*filter;
	QSize			qs;
	TextureBaseWidget	*tbasew;
public:

	ColorEntryWidget(QWidget *p, colorEntry *);
	~ColorEntryWidget();
	void getValue();
	
	virtual QSize	sizeHint() const;
	void	paintEvent(QPaintEvent*);
signals:
	void 	sizeChanged();

};
//----------------------------------------------------


class ColorEntryDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	ColorEntryWidget	*pw;

public:

	ColorEntryDialog(QWidget *p, colorEntry *);
	~ColorEntryDialog();

protected:
	void	paintEvent(QPaintEvent*);
public slots:
	void okayPressed();
	void cancelPressed();
	void setSize();
};


#endif
