/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colorlistdialog.h
*/
#ifndef __NORMALListWidget_H__
#define __NORMALListWidget_H__

#include "texturewidgetbase.h"
#include "texturebasewidget.h"
#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcombobox.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcheckbox.h>

#include "../../3d/textures/normallist.h"
#include "../widgets/spinbox.h"
#include "../widgets/percentwidget.h"
#include "../widgets/tabwidget.h"

class NormalListWidget : public TextureWidgetBase
{
Q_OBJECT
protected:
	normalList *co;
	TabWidget		*tab;
	QComboBox		*combobox;
	QLabel			*l;
	QSize			qs;		
	TextureBaseWidget	*tbasew;

public:

	NormalListWidget(QWidget *p, normalList *);
	~NormalListWidget();

	void 	getValue();
	virtual QSize	sizeHint() const;

protected:
	void	paintEvent(QPaintEvent*);

};

//--------------------------------------------------------

class NormalListDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	NormalListWidget		*pw;

public:

	NormalListDialog(QWidget *p, normalList *);
	~NormalListDialog();

protected:
	void	paintEvent(QPaintEvent*);
public slots:
	void okayPressed();
	void cancelPressed();
};
#endif
