/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentlistdialog.h
*/
#ifndef __PIGMENTListWidget_H__
#define __PIGMENTListWidget_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcombobox.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcheckbox.h>

#include "../../3d/textures/pigmentlist.h"
#include "../widgets/spinbox.h"
#include "../widgets/percentwidget.h"
#include "../widgets/tabwidget.h"
#include "texturewidgetbase.h"
#include "texturebasewidget.h"

class PigmentListWidget : public TextureWidgetBase
{
Q_OBJECT
protected:
	pigmentList *co;
	TabWidget		*tab;
	QComboBox		*combobox;
	QLabel			*l;
	QSize			qs;		
	TextureBaseWidget	*tbasew;

public:

	PigmentListWidget(QWidget *p, pigmentList *);
	~PigmentListWidget();

	void 	getValue();
	virtual QSize	sizeHint() const;

protected:
	void	paintEvent(QPaintEvent*);

};

//--------------------------------------------------------

class PigmentListDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	PigmentListWidget		*pw;

public:

	PigmentListDialog(QWidget *p, pigmentList *);
	~PigmentListDialog();

protected:
	void	paintEvent(QPaintEvent*);
public slots:
	void okayPressed();
	void cancelPressed();
};




#endif
