/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** surfacedialog.cpp
*/
#include "surfacedialog.h"
#include "surfacedialog.moc"

#include <kapp.h>


SurfaceWidget::SurfaceWidget(QWidget *parent,surface *s) :
	TextureWidgetBase(parent,"SurfaceWidget")
{
	sur=s;

	tbasew=new TextureBaseWidget(this,s );	
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	layer=new SpinBox(this,i18n("Layer:"),(double)sur->getLayer());
	layer->switchToIntMode();
	layer->DownTopValue(-1,500);
	layer->setStep(1);
	layer->setValue((double)sur->getLayer() );
	connect(layer,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	paintEvent(NULL);
}

SurfaceWidget::~SurfaceWidget()
{
	if (tbasew) delete tbasew;
	if (layer) delete layer;
}

void SurfaceWidget::getValue()
{
	sur->setLayer( (int)layer->getValue() );
	tbasew->getTextureBase();

}


QSize SurfaceWidget::sizeHint() const
{
	return qs;
}

void SurfaceWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();
int h=tbasew->sizeHint().height();
int y=0,h1=0,w1=0;

	tbasew->setGeometry(10,10,w,h);
	y+=15+h;

	w1=layer->sizeHint().width();
	h1=layer->sizeHint().height();
	
	layer->setGeometry(10,y,w1,h1);

	y+=5+h1;
	w=MAX(w,w1);

	qs.setWidth(w+5);
	qs.setHeight(y+5);
	if (qp) QWidget::paintEvent(qp);
}

//------------------------------------------------------------------------

SurfaceDialog::SurfaceDialog(QWidget *parent,surface *s) :
	QDialog(parent,"SurfaceDialog",true)
{
	setCaption(i18n("Surface") );

	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new SurfaceWidget(this,s);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}

SurfaceDialog::~SurfaceDialog()
{
	if (pw) delete pw;
	if (ok) delete ok;
	if (cancel) delete cancel;
}


void SurfaceDialog::cancelPressed()
{
	QDialog::done(0);
}

void SurfaceDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void SurfaceDialog::paintEvent(QPaintEvent* qp)
{
 	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	pw->setGeometry(0,0,w,h);
	setMinimumSize(w,h);
	setMaximumSize(w,h);

	if (qp) QDialog::paintEvent(qp);
}
