/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** surfacedialog.h
*/
#ifndef __SurfaceDialog_H__
#define __SurfaceDialog_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcombobox.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>

#include "../../3d/textures/texture.h"
#include "../widgets/vectorwidget.h"
#include "../widgets/tabwidget.h"
#include <qlabel.h>
#include <qpopupmenu.h>
#include <qframe.h>

#include "colorwidget.h"
#include "transformationswidget.h"
#include "normaldialog.h"
#include "pigmentdialog.h"
#include "finishdialog.h"
#include "texturebasewidget.h"
#include "texturewidgetbase.h"

class SurfaceWidget : public TextureWidgetBase
{
Q_OBJECT
protected:
	surface  *sur;

	TextureBaseWidget	*tbasew;
	SpinBox			*layer;
	TabWidget		*tab;

	
	QLabel			*label1,*label2,*label3;
	QSize			qs;

public:

	SurfaceWidget(QWidget *p, surface *);
	~SurfaceWidget();
      	void getValue();
	
	virtual QSize	sizeHint() const;
	


protected:
	void	paintEvent(QPaintEvent*);
};


//-------------------------------------------------

class SurfaceDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	SurfaceWidget		*pw;

public:

	SurfaceDialog(QWidget *p, surface *);
	~SurfaceDialog();

protected:
	void	paintEvent(QPaintEvent*);
public slots:
	void okayPressed();
	void cancelPressed();
};

#endif
