/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** surfaceentrywidget.h
*/
#ifndef __SURFACEENTRYWIDGET_H__
#define __SURFACEENTRYWIDGET_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qcheckbox.h>

#include "../../3d/textures/surfaceentry.h"
#include "../widgets/spinbox.h"
#include "../widgets/percentwidget.h"
#include "texturebasewidget.h"
#include "texturewidgetbase.h"

class SurfaceEntryWidget : public TextureWidgetBase
{
Q_OBJECT
protected:
	surfaceEntry *co;
	SpinBox			*range,*layer;
	QSize			qs;
	TextureBaseWidget	*tbasew;
public:

	SurfaceEntryWidget(QWidget *p, surfaceEntry *);
	~SurfaceEntryWidget();
	void getValue();
	
	virtual QSize	sizeHint() const;
	void	paintEvent(QPaintEvent*);
signals:
	void 	sizeChanged();

};
//----------------------------------------------------


class SurfaceEntryDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	SurfaceEntryWidget	*pw;

public:

	SurfaceEntryDialog(QWidget *p, surfaceEntry *);
	~SurfaceEntryDialog();

protected:
	void	paintEvent(QPaintEvent*);
public slots:
	void okayPressed();
	void cancelPressed();
	void setSize();
};


#endif
