/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** textureview.h
*/
#ifndef __TEXTUREATTRIBUTEVIEW_H__
#define __TEXTUREATTRIBUTEVIEW_H__

#include "colorwidget.h"
#include "imagemapdialog.h"
#include "colorlistdialog.h"
#include "colorentrywidget.h"
#include "colormapdialog.h"
#include "pigmentdialog.h"
#include "bumpmapdialog.h"
#include "slopemapdialog.h"
#include "slopeentrywidget.h"
#include "normaldialog.h"
#include "finishdialog.h"
#include "interiordialog.h"
#include "densitydialog.h"
#include "texturedialog.h"
#include "materialdialog.h"
#include "transformationswidget.h"
#include "normallistdialog.h"
#include "normalmapdialog.h"
#include "surfacelistdialog.h"
#include "surfacemapdialog.h"
#include "pigmentlistdialog.h"
#include "pigmentmapdialog.h"
#include "pigmententrywidget.h"
#include "warpwidget.h"
#include "repeatwarpwidget.h"
#include "blackholewarpwidget.h"

#include "previewwidget.h"

#include <qwidget.h>

#include "../../3d/textures/texturebase.h"
#include "texturewidgetbase.h"

#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qtooltip.h>
#include <qscrollview.h>


class	 TextureAttributeView: public  QFrame
{
Q_OBJECT
protected:
	TextureWidgetBase 	*justOpen;
	textureBase		*selTB;

	PreviewWidget		*preview;

	QScrollView		*scroll;

	QWidget	*buttongroup1;
	textureBase	*turbDummy,*transDummy;


public:
	TextureAttributeView(QWidget *p, const char *name);
	~TextureAttributeView();
	//void 	setGeometry(int,int,int,int);
	void 	paintEvent(QPaintEvent *qp);

private slots:
	void changed();

public slots:
	void newTextureSelection(textureBase *);
	void applyChanges();
	void originalValues();

signals:
	void valueChanged(textureBase *);
};

#endif
