/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** TextureListView.cpp
*/
#include "texturelistview.h"
#include "texturelistview.moc"
#include "patternmodifierdialog.h"
#include "densitydialog.h"
#include "colorentrywidget.h"
#include "imagemapdialog.h"
#include "bumpmapdialog.h"
#include "colorlistdialog.h"
#include "colormapdialog.h"
#include "interiordialog.h"
#include "finishdialog.h"
#include "pigmentdialog.h"
#include "normaldialog.h"
#include "finishdialog.h"
#include "interiordialog.h"
#include "texturedialog.h"
#include "surfacedialog.h"
#include "slopemapdialog.h"

#include "../misc/preferences.h"
#include "../misc/imconv.h"

const char *hakenPic[] = {
"15 13 3 1",
" 	c None",
".	c #FFFFFF",
"+	c #000000",
"...............",
"...........++..",
"..........++...",
".........++....",
".........++....",
"........++.....",
"........++.....",
".++....++......",
"..++...++......",
"...++.++.......",
"....++++.......",
".....++........",
"..............."};

TextureListView::TextureListView(QWidget *p,const char *name, TextureLibrary *tl) :
	QWidget(p,name)
{
	isCh = true;
	tlib = tl;
	init();

	// initialize imageconverter
	textureBase::initializeImageConverter(new imConv());
}

TextureListView::~TextureListView()
{
	// deinitialize imageconverter
	textureBase::initializeImageConverter(0);
#ifdef DEBUG
	printf("Closing View");
#endif
}

void TextureListView::loadLib(char *fname)
{
/*
FILE *fp;
media *m;
textureBase *tb;
QString qstr;

	isCh=false;
	if (tlib) delete tlib;
	tlib=new TextureLibrary();
	treelist->setLib(tlib);

	fp=fopen(fname,"r");
	if (fp) {
		m=new media( fp);
		if (m) {
			tlib->setName(qstr);
			tlib->load(m);
			delete m;
		}
		fclose(fp);
	}
	treelist->clear();  // Treelist leeren
	
	tb=tlib->getFirstElement();
	while (tb!=NULL)
       	{
		if (tb) addItem( treelist ,(TextureBook *)tb);

       		tb=tlib->getNextElement();
       }
*/
}

void TextureListView::init()
{
	treelist=new TextureListListView(this,"Texturelistview");
	treelist->setMultiSelection(false);
	treelist->setLib(tlib);
	
	nameColumn=treelist->addColumn("Name");
	activeColumn=treelist->addColumn("a");
	infoColumn=treelist->addColumn("Info");	


	if (isCh==false){
		setWFlags(WStyle_NormalBorder|WStyle_Title);
		newlib=NULL;
	}

	
	connect (treelist,SIGNAL(doubleClicked(QListViewItem *)),this,SLOT(doubleClicked(QListViewItem *)) );
	connect (treelist,SIGNAL(currentChanged(QListViewItem *)),this,SLOT(selChanged(QListViewItem *)) );
	connect (treelist,SIGNAL(popupMenu(QListViewItem *,int,int)),this,SLOT(popupClicked(QListViewItem *,int,int)) );
	connect (treelist,SIGNAL(rightButtonPressed(QListViewItem *,const QPoint &,int)),this,SLOT(rightButtonClicked(QListViewItem *,const QPoint &,int)) );
}

void TextureListView::rightButtonClicked(QListViewItem *qli,const QPoint & qp,int c)
{
}

void TextureListView::MenuItemSel(int i)
{
TextureWindow *tw;
textureBase *tb;
TextureListItem *tli=(TextureListItem *)treelist->currentItem();

	if (tli) tb=(textureBase *)tli->getData();
	else tb=tlib;
	switch(i) {
		case 1:
		{
			tb->addElement( new TextureBook(tb),NULL );
			updateAll();
		}
		break;
		case 2:
			insertLib();
		break;
		case 3:
			tw=new TextureWindow("Material");
			tw->show();
		break;
		case 4:
			saveLib();
		break;
		case 5: //new Material
		{

			if (tb->getType()==TEXTUREBOOK) {
				texture *t= new texture(tb);
				tb->add(t);
				addItem (tli,t);
				return;
			}
			if (tb->getType()==TEXTURELIBRARY) {
				texture *t= new texture(tb);
				tlib->add(t);
				addItem (treelist,t);
				return;
			}	
			tb=tb->getParent();
			while (tb!=NULL) {
				if (tb->getType()==TEXTUREBOOK) {
					texture *t= new texture(tb);
					tb->add(t);
					addItem (tli,t);
					return;
				} else if (tb==tlib) {
					texture *t= new texture(tb);
					tlib->add(t);	
					addItem(treelist,t);
					return;
				}
				tb=tb->getParent();	
			}
		}
		
		break;
		default:
		break;
	}


}

void TextureListView::updateAll()
{
textureBase *tb=tlib->getFirstElement();
TextureListItem *tli=(TextureListItem*)treelist->currentItem();

#ifdef DEBUG
	printf("Updating complete texture-Listview\n");
#endif
//       printf("TLV: %d\n",tlib);
   	if (tli) {
		textureBase *tb2;
		tb2=(textureBase *)(tli->getData());
		if (tb2) tb2->setSelected(false);
	}

	treelist->clear();  // Treelist leeren

	while (tb!=NULL)
       	{
		if (tb) addItem( treelist ,(TextureBook *)tb);
       		tb=tlib->getNextElement();
       	}
	

}

void TextureListView::exportTLib() //export as POV
{
	KFileDialog	*fd;
	QString		qstr;
	char		name[1024];
	FILE		*fp;
	
	fd = new KFileDialog("Export POV");
	fd->setCaption("Export POV");
	qstr = fd->getSaveFileName("","*.pov",this,0);
	if(qstr == "") { delete fd; return; }
	strcpy(name,qstr.data());
	delete fd;

	fp=fopen( (const char *)name,"w+");
	if (fp) {
		tlib->exportPOV(fp,0,5,0,true);
		fclose(fp);
	}
}


void TextureListView::saveLib()
{
	KFileDialog	*fd;
	QString		qstr;
	char		name[1024];
	media		*m;
	Preferences	prefs;
	
	fd = new KFileDialog("Save Library");
	fd->setCaption("Save Library");
	qstr = fd->getSaveFileName(prefs.getPath(prefs.getTexturePath()),"*.3dds",this,0);
	if(qstr == "") { delete fd; return; }
	strcpy(name,qstr.data());
	delete fd;

	m=new media( (const char *)name);
	if (m) {
		tlib->setName(qstr);
		tlib->saveLib(m);
		delete m;
	}
}

void TextureListView::insertLib()
{
	textureBase	*tb;
	KFileDialog	*fd;
	QString		qstr;
	char		name[1024];
	media		*m;
	FILE		*fp;
	Preferences	prefs;
	
	fd = new KFileDialog("Insert Library");
	fd->setCaption("Insert Library");
	qstr = fd->getOpenFileName(prefs.getPath(prefs.getTexturePath()),"*.3dds",this,0);
	if(qstr == "") return;
	strcpy(name,qstr.data());
	delete fd;

	fp=fopen(name,"r");
	if (fp) {
		m=new media( fp);
		if (m) {
			tlib->setName(qstr);
			tlib->load(m);
			delete m;
		}
		fclose(fp);
	}
	treelist->clear();  // Treelist leeren
	
	tb=tlib->getFirstElement();
	while (tb!=NULL)
       	{
		if (tb) addItem( treelist,(TextureBook *)tb);
       		tb=tlib->getNextElement();
       }
}

void TextureListView::setWorld(world *w)
{

textureBase	*tb;

#ifdef DEBUG
	printf("setWorldcalled\n");
#endif
	tlib=w->getTextureLibrary();
	treelist->setLib(tlib);
	treelist->clear();  // Treelist leeren
	
	tb=tlib->getFirstElement();
	while (tb!=NULL)
       	{
		if (tb) addItem( treelist ,(TextureBook *)tb);

       		tb=tlib->getNextElement();
       }
}

void TextureListView::addSubItems(TextureListItem *tli, textureBase *t)
{
TextureListItem *tmp;
textureBase *tb;

	if (!t) return;
	tb=t->getFirstElement();
printf("#4\n");
	while (tb) {
printf("#4a\n");
		tmp=new TextureListItem(tli,tb->getName(),18);
		tmp->setText(infoColumn,tb->getInfo() );
		tmp->setExpandable(tb->hasSubItems() );
		
		if (tb->active()==true)
			tmp->setPixmap(activeColumn,QPixmap(hakenPic));
		else
			tmp->setPixmap(activeColumn,QPixmap());
			
		tmp->setData(tb);	
		tmp->setPixmap(nameColumn,QPixmap(tb->getXPM()));
		tmp->setOpen( tb->isOpen() );

		if (tb->isSelected())
			treelist->setCurrentItem(tmp);

		if (tb->hasSubItems()==true)
			addSubItems(tmp,tb);
			
		tb=t->getNextElement();
        }

}

void TextureListView::addItem(TextureListItem *tli, textureBase *t)
{
TextureListItem *tmp;

	if (!t) return;
	tmp = new TextureListItem(tli,t->getName(),18);
	tmp->setText(infoColumn,t->getInfo());

	tmp->setExpandable(t->hasSubItems() );
	if (t->active()==true)
		tmp->setPixmap(activeColumn,QPixmap(hakenPic));
	else
		tmp->setPixmap(activeColumn,QPixmap());

	if (t->isSelected()) treelist->setCurrentItem(tli);

	tmp->setData(t);	
	tmp->setPixmap(nameColumn,QPixmap(t->getXPM()));
	tmp->setOpen( t->isOpen() );

	if (t->hasSubItems()==true) addSubItems(tmp,t);
}

void TextureListView::addItem(TreeList *tl, textureBase *t)
{
TextureListItem *tmp;
textureBase *tb;

	if (t==NULL) return;
	tmp=new TextureListItem(tl,t->getName(),18);
	tmp->setText(infoColumn,t->getInfo());
	tmp->setExpandable(t->hasSubItems() );
	if (t->active()==true)
		tmp->setPixmap(activeColumn,QPixmap(hakenPic));
	else
		tmp->setPixmap(activeColumn,QPixmap());
	tmp->setData(t);	
	tmp->setPixmap(nameColumn,QPixmap(t->getXPM()));
	tmp->setOpen( t->isOpen() );

	if (t->isSelected()) treelist->setCurrentItem(tmp);

	tb=t->getFirstElement();
	while (tb!=NULL) {
		addItem(tmp,tb );
		tb=t->getNextElement();
	}
}


void TextureListView::updateItem(TextureListItem *tli)
{
textureBase *tb;
	
	if (!tli) return;
	tb=(textureBase *)tli->getData();
	if (!tb) return;

	tli->setText(infoColumn,tb->getInfo());
	tli->setPixmap(nameColumn,QPixmap(tb->getXPM()));
	tli->setText(nameColumn,tb->getName() );
	tli->setExpandable(tb->hasSubItems() );
	tli->setOpen( tb->isOpen() );
	if (tb->active()==true)
		tli->setPixmap(activeColumn,QPixmap(hakenPic));
	else
		tli->setPixmap(activeColumn,QPixmap());

	//if (tb->isSelected()) treelist->setCurrentItem(tli);

	tli->setData(tb);	

	if (tli->childCount()>0) {
		TextureListItem *a=(TextureListItem *)tli->firstChild();
		while (a!=NULL) {
			tli->removeItem(a);
			a=(TextureListItem *)tli->firstChild();
		}

	}

	if (tb->hasSubItems()==true) {
		//tli->setOpen(true);
		addSubItems(tli,tb);
	}
}

void TextureListView::StandardPopupSel(int x)
{
TextureListItem *lastItem=(TextureListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
QString qs;
char *txt;

	if (x==2) { // Rename
		RenameDialog *rn=new RenameDialog(NULL,(char *)tb->getName() );
		txt=strdup(rn->exec());
		delete rn;
		if (txt!=NULL) {
			tb->setName(txt);	
			lastItem->setText(nameColumn,tb->getName() );
			if (tb->getType()==TEXTURE) {		
				emit changedTexture( (texture *)tb);
			} else emit newTextureSelection(tb);
		}
		return;
	
	}
	if (x==3) { // active
		TextureListItem *t1=(TextureListItem*)lastItem->parent();
		textureBase *t2;
		
                if (!t1) return;

		t2=(textureBase *)t1->getData();
		t2->setActive( !tb->active(),tb );
		updateItem((TextureListItem *)(lastItem->parent()) );
		return;
	}

	if (x==13) { // Delete
		TextureListItem *p=(TextureListItem *)(lastItem->parent());

		if (QMessageBox::warning(this,
			i18n("K4DE - Delete item ?"),
			i18n("Are you sure, that you want to delete this item ?"),
			i18n("&Yes"),i18n("&No"),i18n("Cancel"),1,2) ==0) {
			if (p!=NULL) {
				textureBase *t=p->getData();
				t->remove(tb);
				p->removeItem(lastItem);
				updateItem(p);
				return;
			} else {
				//TextureListItem *p=(TextureListItem *)lastItem;
				//TextureLibrary *t=(TextureLibrary *)p->getData();	
				tlib->remove(tb);
				delete lastItem;
			}
		}
	}
}


void TextureListView::popupClicked(QListViewItem *qli,int x, int y)
{
TextureListItem *tli=(TextureListItem *)qli;
textureBase	*tb=tli->getData();
QPopupMenu	*popup,*childPopup=NULL;
int		i,j,c=0;
QString		name_list[50];
ttyp		id_list[50];
QString 	ntmp;
ttyp		itmp;


	if (!tb) return;

	popup=new QPopupMenu(NULL);
	popup->setCheckable(true);
        c=0;
	if (tb->hasSubItems()==true) {
	      	for(
			i = TXT_TYPE_START;
			i < UNDEFINEDTI;
			i++)
		{
			if (tb->canAdd((ttyp)i)==TRUE) {
				if (!childPopup) childPopup=new QPopupMenu(NULL);
				if (childPopup) {
					//childPopup->insertItem(i18n(tb->getTypeName(i)),i);
					name_list[c]=(QString)tb->getTypeName((ttyp)i);
					id_list[c]=(ttyp)i;
					c++;
				}
			}
		}
		if (childPopup) {
			popup->insertItem(i18n("New"),childPopup);
			for (i=1;i<c;i++) {
				for (j=0;j<c;j++) {
					if ( strcmp(name_list[j],name_list[j+1])>0 ) {
						ntmp=name_list[j+1];
						itmp=id_list[j+1];
						name_list[j+1]=name_list[j];
						name_list[j]=ntmp;
						id_list[j+1]=id_list[j];
						id_list[j]=itmp;						
					}
				}
			}	
			ntmp=name_list[0].left(2);
			for (i=0;i<c;i++) {
				if (strcmp(ntmp,name_list[i].left(2))) {
					ntmp=name_list[i].left(2);
					childPopup->insertSeparator();
				}
				childPopup->insertItem( (const char*)name_list[i].right(name_list[i].length()-2),id_list[i]);
			}
			connect(childPopup,SIGNAL(activated(int)),this,SLOT(insertItemSelected(int)) );
		}
	}



	popup->insertItem("Rename",2);
	popup->insertSeparator();
	popup->insertItem("Active",3);
	popup->setItemChecked(3,tb->active());
	popup->insertSeparator();
	//popup->insertItem("Cut",10);
	//popup->insertItbem("Copy",11);
	//popup->insertItem("Paste",12);
	popup->insertItem("Delete",13);	
	//popup->insertSeparator();
	//popup->insertItem("Properties",20);	
	connect(popup,SIGNAL(activated(int)),this,SLOT(StandardPopupSel(int)) );	
	
	popup->exec(QCursor::pos());

	if (childPopup) {
		disconnect(childPopup,SIGNAL(activated(int)),this,SLOT(insertItemSelected(int)) );	
		delete childPopup;
		childPopup=NULL;
	}
	delete popup;
	popup=NULL;
}


void TextureListView::insertItemSelected(int x)
{
TextureListItem *lastItem=(TextureListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
textureBase *i=NULL;

	if (!tb) return;	
	switch(x) {
		case COLOR:
			i=(textureBase*)new color(tb);
		break;
		case COLORMAP:
			i=(textureBase*)new colorMap(tb);
		break;
		case COLORLIST:
			i=(textureBase*)new colorList(tb);
		break;
		case PIGMENTMAP:
			i=(textureBase*)new pigmentMap(tb);
		break;
		case PIGMENTLIST:
			i=(textureBase*)new pigmentList(tb);
		break;
		case IMAGEMAP:
			i=(textureBase*)new imageMap(tb);
		break;
		case PIGMENT:
			i=(textureBase*)new pigment(tb);
		break;
		case BUMPMAP:
			i=(textureBase*)new bumpMap(tb);
		break;
		case NORMAL:
			i=(textureBase*)new normal(tb);
		break;
		case TEXTURE:
			i=(textureBase*)new texture(tb);
		break;
		case TEXTURELIBRARY:
			//i=(textureBase*)new color(tb);
		break;
		case FINISH:
			i=(textureBase*)new finish(tb);
		break;
		case MEDIA:
			//i=(textureBase*)new media(tb);
		break;
		case TEXTUREBOOK:
			//i=(textureBase*)new interior(tb);
		break;
		case BITMAPMODIFIER:
			//i=(textureBase*)new color(tb);
		break;
		case TRANSFORMATIONS:
			i=(textureBase*)new Transformations(tb);
		break;
		case MAPMODIFIER:
			//i=(textureBase*)new color(tb);
		break;
		case TURBULENCEMODIFIER:
			i=(textureBase*)new Turbulence(tb);
		break;
		case PATTERNMODIFIER:
			//i=(textureBase*)new color(tb);
		break;
		case COLORENTRY:
			i=(textureBase*)new colorEntry(tb);
		break;
		case DENSITY:
			i=(textureBase*)new Density(tb);
		break;
		case NORMALMAP:
			i=(textureBase*)new normalMap(tb);
		break;
		case NORMALLIST:
			i=(textureBase*)new normalList(tb);
		break;
		case SLOPEENTRY:
			i=(textureBase*)new color(tb);
		break;
		case SLOPEMAP:
			i=(textureBase*)new color(tb);
		break;
		case SURFACE:
			i=(textureBase*)new surface(tb);
		break;
		case NORMALENTRY:
			i=(textureBase*)new normalEntry(tb);
		break;
		case SURFACEENTRY:
			i=(textureBase*)new surfaceEntry(tb);
		break;
		case SURFACELIST:
			i=(textureBase*)new surfaceList(tb);
		break;
		case SURFACEMAP:
			i=(textureBase*)new surfaceMap(tb);
		break;
		case PIGMENTENTRY:
			i=(textureBase*)new pigmentEntry(tb);
		break;
		case WARP:
			i=(textureBase*)new warp(tb);
		break;
		case REPEATWARP:
			i=(textureBase*)new repeatWarp(tb);
		break;
		case BLACKHOLEWARP:
			i=(textureBase*)new blackHoleWarp(tb);
		break;
		default:
		i=NULL;
		break;
	}
	if (i) {
		tb->addElement(i,NULL);
		updateItem(lastItem);
	}
}

void TextureListView::updateSelected()
{
TextureListItem *lastItem=(TextureListItem*)treelist->currentItem();
	updateItem(lastItem);	
}

void TextureListView::selChanged(QListViewItem *qli)
{
TextureListItem *tli=(TextureListItem *)qli;
textureBase *tb;
TextureListItem *lastItem=(TextureListItem*)treelist->currentItem();
	if (tli) {
		tb=(textureBase *)lastItem->getData();	
		emit newTextureSelection(tb);

	}
}

void TextureListView::doubleClicked(QListViewItem *qli)
{
TextureListItem *tli=(TextureListItem *)qli;
textureBase *tb;
TextureListItem *lastItem=(TextureListItem*)treelist->currentItem();

	selChanged(qli);
	tb=(textureBase *)lastItem->getData();	
	tb->setOpen(tli->isOpen() );
}

void TextureListView::paintEvent(QPaintEvent *qp)
{
	int w=width();
	int h=height();

 	treelist->setGeometry(0,0,w,h);
	treelist->setColumnWidth(nameColumn,10*w/10); 	// Baumstruktur
	treelist->setColumnWidth(infoColumn,0*w/10);	// User-Infos
	treelist->setColumnWidth(activeColumn,0*w/10);  // Aktiv

	//if (newlib) newlib->setGeometry(3,10,buttonw-5,40);
	//newbook->setGeometry(3,83,buttonw-5,40);
	//inslib->setGeometry(3,133,buttonw-5,40);
	//savelib->setGeometry(3,183,buttonw-5,40);

 	QWidget::paintEvent(qp);

}

//======================================================================

TextureListListView::TextureListListView(QWidget *p,char *n):TreeList(p,n)
{
	DnDPopup=new QPopupMenu(NULL);
	DnDPopup->insertItem("Copy",0);
	//DnDPopup->insertItem("Move",1);	

	tview=(TextureListView *)p;
}

void TextureListListView::setLib(TextureLibrary *t)
{
	tlib=t;
}

TextureListListView::~TextureListListView()
{
}


void	TextureListListView::startDragCopy(QListViewItem *item,QWidget *dragsource)
{
	if(!item || !dragsource)
		return;

	QPixmap		pixmap;
	Drag3DDS	*drag;
	textureBase	*tb;

	tb=((TextureListItem *)item)->getData();
	if (!tb) return;

	pixmap = *item->pixmap(0);

	drag = new Drag3DDS("3dds/texture",dragsource);
	drag->encode(tb);
	drag->setPixmap(pixmap);
	drag->dragCopy();
}

void	TextureListListView::startDragMove(QListViewItem *item,QWidget *dragsource)
{
}

void	TextureListListView::dragMoveEvent(QDragMoveEvent *dme)
{
	QPoint		p = dme->pos();
	TextureListItem	*li = (TextureListItem *)itemAt(p);



		
	if (Drag3DDS::canDecode(dme,"3dds/texture")) {
		textureBase	*t;
		Drag3DDS::decode( (QDragMoveEvent *)dme,&t, (const char *)"3dds/texture");// && t);
		if (li) {		
			textureBase	*tb=(textureBase *)li->getData();
			if (tb->canDrop(t)==true ) dme->accept();
			else dme->ignore();
		} else{
			if ((t->getType()==TEXTURE)||(t->getType()==TEXTUREBOOK)) {
				dme->accept();
			} else dme->ignore();
		}
	} else dme->ignore();
}

void	TextureListListView::dropEvent(QDropEvent *de)
{

	textureBase		*t;
	int x;

	if (Drag3DDS::decode(de,&t,"3dds/texture") && t)
	{
		printf("Dropped Texture over TextureListView\n");

		QPoint		p = de->pos();
		QListViewItem	*li = itemAt(p);
		if (li!=NULL) {
			textureBase 	*tb=((TextureListItem *)li)->getData();
			if (tb->isEqual(t)==true) return;

			x=DnDPopup->exec(QCursor::pos());

			if (x==0) {
				printf("Copy %s to %s\n",t->getName(),tb->getName());
				tb->add(t);        	
                	}
			if (x==1){
				printf("Move\n");
				tb->add(t);        	
			}
			//x=-1 :Escape gedrckt....
        		tview->updateItem( (TextureListItem *)li);
			return;
		} else {
			x=DnDPopup->exec(QCursor::pos());

			if (x==0) {
				tlib->add(t);        	
                	}
			if (x==1){
				tlib->add(t);        	
			}
			tview->updateAll();
			return;
		}
	}


}

void	TextureListListView::dragEnterEvent(QDragEnterEvent *de)
{
	if(Drag3DDS::canDecode(de,"3dds/texture"))
	{
		de->accept();
	}
}

void	TextureListListView::dragLeaveEvent(QDragLeaveEvent *)
{
    // Give the user some feedback...
}




TextureListItem::TextureListItem(QListView *p,int h) :
	TreeListItem(p,h)
{
}

TextureListItem::TextureListItem(QListView *p,const char* t1,int h) :
	TreeListItem(p,t1,h)
{
}

TextureListItem::TextureListItem(QListViewItem *p,int h) :
	TreeListItem(p,h)
{
}

TextureListItem::TextureListItem(QListViewItem *p,const char* t1,int h) :
	TreeListItem(p,t1,h)
{
}

void	TextureListItem::setData(textureBase *tb)
{
	data = tb;
}

textureBase 	*TextureListItem::getData()
{
	return data;
}

