/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** textureview.h
*/
#ifndef __TEXTUREVIEW_H__
#define __TEXTUREVIEW_H__


#include "texturelistview.h"
#include "textureattributeview.h"

#include <klocale.h>
#include <ktoolbar.h>
#include <knewpanner.h>
#include <qmenubar.h>
#include "../editor/mainwin.h"
#include <chunk.h>
#include <objects.h>
#include "previewview.h"

class TextureListView;
class TextureAtrributeView;

class	 TextureView: public  KNewPanner
{
Q_OBJECT
protected:

	TextureListView 	*tlv;
	TextureAttributeView 	*tav;
	PreviewView		*prv;
	KNewPanner		*panner;
	TextureLibrary		*tlib;

public:
	TextureView(QWidget *p, const char *name);
	~TextureView();
	void	resizeEvent(QResizeEvent*);
	TextureListView 	*getTextureListView();
	TextureLibrary		*getTextureLibrary();

public slots:
	void setWorld(world *);
	void MenuItemSel(int);
signals:
	void changedTexture(texture *);
	void changedLibrary(TextureLibrary *);
};

#endif
