/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** vectorwidget.h
*/
#ifndef __VECTORWIDGET_H__
#define __VECTORWIDGET_H__

#include <matmath.h>

#include <qwidget.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qcheckbox.h>
#include <qsize.h>
#include <qgroupbox.h>

#include "spinbox.h"

class	 VectorWidget: public QGroupBox
{
Q_OBJECT
protected:

	SpinBox			*xe,*ye,*ze;
	QCheckBox		*check;
	Vector3			vector;
	bool			allequal;
	char			*titlelabel;
	QSize			qs;
	int			layouttype; // 0 = vertical, 1 = horizontal
	QLabel			*title;

public:
	VectorWidget(QWidget *parent,const char *name,int layouttype = 0);
	~VectorWidget();

	Vector3		getVector();
	void		setVector(Vector3);
        QSize		sizeHint();
	
public slots:
	void		paintEvent(QPaintEvent*);

protected slots:
	void		ValueChanged();
	void		CheckPressed();
	
signals:
	void		changed();
	
protected:
	void		layout();

};


#endif

