/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** xdata.cpp
*/
#include "xdata.h"

#include <media.h>
#include <chunk.h>

#include <string.h>

xdata::xdata(const char *name)
{
	if(name)
		dataname = strdup(name);
	else
		dataname = 0;
	type = INVALID;
}

xdata::~xdata()
{
	if(dataname)
		delete dataname;

	if(type == STRING)
	{
		if(data.vstring)
			delete data.vstring;
	}
}

const char	*xdata::name()
{
	return dataname;
}

int	xdata::setData(bool value)
{
	if(type == STRING)
	{
		if(data.vstring)
			delete data.vstring;
	}
	type = BOOL;
	data.vbool = value;

	return 0;
}

int	xdata::setData(char value)
{
	if(type == STRING)
	{
		if(data.vstring)
			delete data.vstring;
	}
	type = CHAR;
	data.vchar = value;

	return 0;
}

int	xdata::setData(int value)
{
	if(type == STRING)
	{
		if(data.vstring)
			delete data.vstring;
	}
	type = INT;
	data.vint = value;

	return 0;
}

int	xdata::setData(double value)
{
	if(type == STRING)
	{
		if(data.vstring)
			delete data.vstring;
	}
	type = DOUBLE;
	data.vdouble = value;

	return 0;
}

int	xdata::setData(const char *value)
{
	if(type == STRING)
	{
		if(data.vstring)
			delete data.vstring;
	}
	type = STRING;
	if(value)
		data.vstring = strdup(value);
	else
		data.vstring = 0;

	return 0;
}
	
int	xdata::getData(bool &value)
{
	if(type != BOOL)
		return -1;

	value = data.vbool;

	return 0;
}

int	xdata::getData(char &value)
{
	if(type != CHAR)
		return -1;

	value = data.vchar;

	return 0;
}

int	xdata::getData(int &value)
{
	if(type != INT)
		return -1;

	value = data.vint;

	return 0;
}

int	xdata::getData(double &value)
{
	if(type != DOUBLE)
		return -1;

	value = data.vdouble;

	return 0;
}

int	xdata::getData(const char *&value)
{
	if(type != STRING)
		return -1;

	value = data.vstring;

	return 0;
}

int	xdata::isBool()
{
	return (type == BOOL);
}

int	xdata::isChar()
{
	return (type == CHAR);
}

int	xdata::isInt()
{
	return (type == INT);
}

int	xdata::isDouble()
{
	return (type == DOUBLE);
}

int	xdata::isString()
{
	return (type == STRING);
}

int	xdata::load(media *m,int len,int ver)
{
	chunk	c;
	char	chnk[4];
	int	l;
	
	if(!m)
		return -1;
		
	switch(ver)
	{
		case 0:
		case -1:
			c.setMedia(m);
			c.readChunk(chnk,l);
			if(strncmp("XDTA",chnk,4) == 0)
			{
				dataname = c.readName();
				type = (XD_TYPE)c.readInt();
			
				switch(type)
				{
					case BOOL:
						data.vbool = (bool)c.readInt();
					break;
					case CHAR:
						data.vchar = (char)c.readInt();
					break;
					case INT:
						data.vint = c.readInt();
					break;
					case DOUBLE:
						data.vdouble = c.readDouble();
					break;
					case STRING:
						data.vstring = c.readName();
					break;
					default:
						printf("Unknown Datatype %i!\n",(int)type);
				}
			}
			else
			{
				c.rejectChunk();
				return -3;
			}
		break;
		default:
			return -2;
	}
	
	return 0;
}

int	xdata::save(media *m,int ver)
{
	chunk	c;
	
	if(!m)
		return -1;
		
	switch(ver)
	{
		case 0:
		case -1:
			c.setMedia(m);
			c.writeChunk("XDTA");
	
			c.writeName(name());
			c.writeInt(type);
			
			switch(type)
			{
				case BOOL:
					c.writeInt(data.vbool);
				break;
				case CHAR:
					c.writeInt(data.vchar);
				break;
				case INT:
					c.writeInt(data.vint);
				break;
				case DOUBLE:
					c.writeDouble(data.vdouble);
				break;
				case STRING:
					c.writeName(data.vstring);
				break;
				default:
					printf("Unknown Datatype %i!\n",(int)type);
			}
						
			c.writeChunkLen();
		break;
		default:
			return -2;
	}
	
	return 0;
}


xdatacol::xdatacol(const char *name)
{
	if(name)
		colname = strdup(name);
	else
		colname = 0;
}

xdatacol::~xdatacol()
{
	int		i;
	
	if(colname)
		delete colname;

	for(i = 0;i < datalist.length();i++)
	{
		delete datalist[i];	
	}
	datalist.empty();
}

const char	*xdatacol::name()
{
	return colname;
}


int	xdatacol::setData(const char *dataname,bool value)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		datalist[n]->setData(value);
	}
	else
	{
		xdata	*xd;

		xd = new xdata(dataname);
		xd->setData(value);
		datalist.append(xd);
	}

	return 0;
}

int	xdatacol::setData(const char *dataname,char value)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		datalist[n]->setData(value);
	}
	else
	{
		xdata	*xd;

		xd = new xdata(dataname);
		xd->setData(value);
		datalist.append(xd);
	}

	return 0;
}

int	xdatacol::setData(const char *dataname,int value)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		datalist[n]->setData(value);
	}
	else
	{
		xdata	*xd;

		xd = new xdata(dataname);
		xd->setData(value);
		datalist.append(xd);
	}

	return 0;
}

int	xdatacol::setData(const char *dataname,double value)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		datalist[n]->setData(value);
	}
	else
	{
		xdata	*xd;

		xd = new xdata(dataname);
		xd->setData(value);
		datalist.append(xd);
	}

	return 0;
}

int	xdatacol::setData(const char *dataname,const char *value)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		datalist[n]->setData(value);
	}
	else
	{
		xdata	*xd;

		xd = new xdata(dataname);
		xd->setData(value);
		datalist.append(xd);
	}

	return 0;
}

int	xdatacol::getData(const char *dataname,bool &value)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		return datalist[n]->getData(value);
	}

	return -2;
}

int	xdatacol::getData(const char *dataname,char &value)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		return datalist[n]->getData(value);
	}

	return -2;
}

int	xdatacol::getData(const char *dataname,int &value)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		return datalist[n]->getData(value);
	}

	return -2;
}

int	xdatacol::getData(const char *dataname,double &value)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		return datalist[n]->getData(value);
	}

	return -2;
}

int	xdatacol::getData(const char *dataname,const char *&value)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		return datalist[n]->getData(value);
	}

	return -2;
}
	
int	xdatacol::removeData(const char *dataname)
{
	if(find(dataname) >= 0)
	{
		delete datalist.deleteCurrent();
		
		return 0;
	}

	return -2;
}


int	xdatacol::hasData(const char *dataname)
{
	return (find(dataname) >= 0);
}

int	xdatacol::isBool(const char *dataname)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		return datalist[n]->isBool();
	}

	return -2;
}

int	xdatacol::isChar(const char *dataname)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		return datalist[n]->isChar();
	}

	return -2;
}

int	xdatacol::isInt(const char *dataname)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		return datalist[n]->isInt();
	}

	return -2;
}

int	xdatacol::isDouble(const char *dataname)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		return datalist[n]->isDouble();
	}

	return -2;
}

int	xdatacol::isString(const char *dataname)
{
	int	n;

	if((n = find(dataname)) >= 0)
	{
		return datalist[n]->isString();
	}

	return -2;
}

int	xdatacol::find(const char *dataname)
{
	int	n;

	for(n = 0;n < datalist.length();n++)
	{
		if(strcmp(datalist[n]->name(),dataname) == 0)
			return n;
	}

	return -1;
}

int	xdatacol::load(media *m,int len,int ver)
{
	chunk	c;
	char	chnk[4];
	int	l,pos;
	
	if(!m)
		return -1;
		
	switch(ver)
	{
		case 0:
		case -1:
			c.setMedia(m);
			c.readChunk(chnk,l);
			if(strncmp("XDTC",chnk,4) == 0)
			{
				pos = m->tell();
				while(m->tell() < pos + l)
				{
					xdata	*xd = new xdata(0);
					
					xd->load(m,l - (m->tell() - pos),ver);
					datalist.append(xd);
				}
			}
			else
			{
				c.rejectChunk();
				return -3;
			}
		break;
		default:
			return -2;
	}
	
	return 0;
}

int	xdatacol::save(media *m,int ver)
{
	chunk	c;
	int	i;
	
	if(!m)
		return -1;
		
	switch(ver)
	{
		case 0:
		case -1:
			c.setMedia(m);
			c.writeChunk("XDTC");
	
			for(i = 0;i < datalist.length();i++)
			{
				datalist[i]->save(m,ver);
			}
			
			c.writeChunkLen();
		break;
		default:
			return -2;
	}
	
	return 0;
}

extradata::extradata()
{
}

extradata::~extradata()
{
	int		i;
	
	
	for(i = 0;i < collist.length();i++)
	{
		delete collist[0];
	}
	collist.empty();
}

int	extradata::setData(const char *colname,const char *dataname,bool value)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		collist[n]->setData(dataname,value);
	}
	else
	{
		xdatacol	*xd;

		xd = new xdatacol(colname);
		xd->setData(dataname,value);
		collist.append(xd);
	}

	return 0;
}

int	extradata::setData(const char *colname,const char *dataname,char value)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		collist[n]->setData(dataname,value);
	}
	else
	{
		xdatacol	*xd;

		xd = new xdatacol(colname);
		xd->setData(dataname,value);
		collist.append(xd);
	}

	return 0;
}

int	extradata::setData(const char *colname,const char *dataname,int value)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		collist[n]->setData(dataname,value);
	}
	else
	{
		xdatacol	*xd;

		xd = new xdatacol(colname);
		xd->setData(dataname,value);
		collist.append(xd);
	}

	return 0;
}

int	extradata::setData(const char *colname,const char *dataname,double value)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		collist[n]->setData(dataname,value);
	}
	else
	{
		xdatacol	*xd;

		xd = new xdatacol(colname);
		xd->setData(dataname,value);
		collist.append(xd);
	}

	return 0;
}

int	extradata::setData(const char *colname,const char *dataname,const char *value)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		collist[n]->setData(dataname,value);
	}
	else
	{
		xdatacol	*xd;

		xd = new xdatacol(colname);
		xd->setData(dataname,value);
		collist.append(xd);
	}

	return 0;
}

int	extradata::getData(const char *colname,const char *dataname,bool &value)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		return collist[n]->getData(dataname,value);
	}

	return -3;
}

int	extradata::getData(const char *colname,const char *dataname,char &value)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		return collist[n]->getData(dataname,value);
	}

	return -3;
}

int	extradata::getData(const char *colname,const char *dataname,int &value)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		return collist[n]->getData(dataname,value);
	}

	return -3;
}

int	extradata::getData(const char *colname,const char *dataname,double &value)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		return collist[n]->getData(dataname,value);
	}

	return -3;
}

int	extradata::getData(const char *colname,const char *dataname,const char *&value)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		return collist[n]->getData(dataname,value);
	}

	return -3;
}

int	extradata::removeData(const char *colname,const char *dataname)
{
	if(find(colname) >= 0)
	{
		delete collist.deleteCurrent();
		
		return 0;
	}

	return -2;
}


int	extradata::hasData(const char *colname,const char *dataname)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		return (collist[n]->hasData(dataname));
	}

	return -3;
}

int	extradata::hasDataCollection(const char *colname)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		return 0;
	}

	return -1;
}

int	extradata::isBool(const char *colname,const char *dataname)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		return collist[n]->isBool(dataname);
	}

	return -3;
}

int	extradata::isChar(const char *colname,const char *dataname)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		return collist[n]->isChar(dataname);
	}

	return -3;
}

int	extradata::isInt(const char *colname,const char *dataname)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		return collist[n]->isInt(dataname);
	}

	return -3;
}

int	extradata::isDouble(const char *colname,const char *dataname)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		return collist[n]->isDouble(dataname);
	}

	return -3;
}

int	extradata::isString(const char *colname,const char *dataname)
{
	int	n;

	if((n = find(colname)) >= 0)
	{
		return collist[n]->isString(dataname);
	}

	return -3;
}

int	extradata::find(const char *dataname)
{
	int	n;

	for(n = 0;n < collist.length();n++)
	{
		if(strcmp(collist[n]->name(),dataname) == 0)
			return n;
	}

	return -1;
}

int	extradata::load(media *m,int len,int ver)
{
	chunk	c;
	char	chnk[4];
	int	l,pos;
	
	if(!m)
		return -1;
		
	switch(ver)
	{
		case 0:
		case -1:
			c.setMedia(m);
			c.readChunk(chnk,l);
			if(strncmp("XTDT",chnk,4) == 0)
			{
				pos = m->tell();
				while(m->tell() < pos + l)
				{
					xdatacol *xdc = new xdatacol(0);
					
					xdc->load(m,l - (m->tell() - pos),ver);
					collist.append(xdc);
				}
			}
			else
			{
				c.rejectChunk();
				return -3;
			}
		break;
		default:
			return -2;
	}
	
	return 0;
}

int	extradata::save(media *m,int ver)
{
	chunk	c;
	int	i;
	
	if(!m)
		return -1;
		
	switch(ver)
	{
		case 0:
		case -1:
			c.setMedia(m);
			c.writeChunk("XTDT");
	
			for(i = 0;i < collist.length();i++)
			{
				collist[i]->save(m,ver);
			}
			
			c.writeChunkLen();
		break;
		default:
			return -2;
	}
	
	return 0;
}





