/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** avi.h
*/
#ifndef __AVI_H__
#define __AVI_H__

#include <stdio.h>

extern "C"
{
#include <jpeglib.h>
}

class avi
{
protected:
	// The number of bytes written to the file by the JPEG Compresser
	int	numbytes;
	int	use_quant_table;
	
        char	*fn;
        FILE	*fp;

        int	frames;
        int	w,h;
        char	compression[4];

public:
	avi();
	avi(const char *filename);
	~avi();
	
	int		initializeMovie();
	void		loadFrame(unsigned char *buffer,int framenum);
	void		writeMovie(int width_oput,int height_out,int frames_out);
	void		writeFrame(unsigned char *buffer,int width_out,int height_out);
	void		writeBlankFrame(int width_out,int height_out);
	
private:
	void		init();
	void		block_handle(FILE *fp,int fourcc);
	int		get_fcc(FILE *fp);
	void		bfcc(FILE *fp,int num);
	void		put_fcc(FILE *fp,int num);
	void		put_tcc(FILE *fp,int num);

	void		addHuffmanTable(j_decompress_ptr dinfo,JHUFF_TBL **htblptr,const UINT8 *bits,const UINT8 *val);
	void		setupStdHuffmanTables(j_decompress_ptr dinfo);
	void		decodeJPEG(FILE *inFile,unsigned char *outBuffer);
	void		compressJPEG(unsigned char *outbuffer,unsigned char *inBuffer,int width,int height);
	void		initDestination(j_compress_ptr cinfo);
	bool		emptyOutputBuffer(j_compress_ptr cinfo);
	void		terminateDestination(j_compress_ptr cinfo);
	void		jpegStdioDestination(j_compress_ptr cinfo,unsigned char *outbuffer);
	
	// These typedefs code is pretty much all gleaned from aviriff.h,
	// do a net search if you want it

	typedef struct _riffchunk
	{
		char fcc[4];
		int cb;
	}
	RIFFCHUNK;

	typedef struct _rifflist
	{
		char fcc[4];
		int cb;
		char ListType[4];
	}
	RIFFLIST;


	#define ckidMAINAVIHEADER FCC('avih')
	typedef struct _avimainheader
	{
		char fcc[4];
		int cb;
		int MicoSecPerFrame;
		int MaxBytesPerSec;
		int PaddingGranularity;
		int Flags;

		#define AVIF_HASINDEX 0x00000010
		#define AVIF_MUSTUSEINDEX 0x00000020
		#define AVIF_ISINTERLEAVED 0x00000100
		#define AVIF_TRUSTCKTYPE 0x00000800
		#define AVIF_WASCAPTUREFILE 0x00010000
		#define AVIF_COPYRIGHTED 0x00020000

		int TotalFrames;
		int InitialFrames;
		int Streams;
		int SuggestedBufferSize;
		int Widget;
		int Height;
		int Reserved[4];
	} AVIMAINHEADER;

	#define ckidSTREAMLIST FCC('strl')
	#define ckidSTREAMHEADER FCC('strh')
	typedef struct _avistreamheader
	{
		char fcc[4];
		int cb;
		char Type[4];

		#define streamtypeVIDEO FCC('vids')
		#define streamtypeAUDIO FCC('auds')
		#define streamtypeMIDI  FCC('mids')
		#define streamtypeTEXT  FCC('txts')

		char Handler[4];
		int Flags;

		#define AVISF_DISABLED 0x00000001
		#define AVISF_VIDEO_PALCHANGES 0x00010000

		short Priority;
		short Language;
		int InitialFrames;
		int Scale;
		int Rate;
		int Start;
		int Length;
		int SuggestedBufferSize;
		int Quality;
		int SampleSize;
		struct
		{
			short left;
			short top;
			short right;
			short bottom;
		}
		Frame;
	} AVISTREAMHEADER;
	
	#define ckidSTREAMFORMAT FCC('strf')

	#define ckidAVIOLDINDEX FCC('idx1')

/* The following code shamelessly ripped from the IJG (independant jpeg groups)
 * libjpeg implementation.... it's basically jdatadst.c hacked up to return the
 * number of bytes of data it wrote */

	typedef struct
	{
		struct jpeg_destination_mgr	pub;		/* public fields */

		unsigned char			*outbuffer;	/* target stream */
		JOCTET				*buffer;	/* start of buffer */
	}
	destination_mgr;

	typedef destination_mgr * dest_ptr;

	#define OUTPUT_BUF_SIZE  4096   /* choose an efficiently fwrite'able size */
	#define JFWRITE(file,buf,sizeofbuf) ((size_t) fwrite((const void *) (buf), (size_t) 1, (size_t) (sizeofbuf), (file)))

};

#endif
