/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** glyph.h
*/
#ifndef __GLYPH_H__
#define __GLYPH_H__

#include <matmath.h>

class fontglyph
{
protected:
	char	*name;
	int	ncontours;	// Wieviele Konturen hat das Zeichen
	int	npoints;	// Wieviele Punkte hat das Zeichen
	Vector2	*points;
	char	*flags;		// Dieses Flag gibt zunchst nur an,
				// ob der Punkt ein on-point oder off-point ist
	int	*contours;

	double	w,h,a;		// Breite und Hhe des Buchstaben

public:
	fontglyph();
	fontglyph(char *n);
	fontglyph(char c);
	~fontglyph();

	void	setName(char *n);
	void	setName(char c);
	char	*getName();
	void	addPoint(Vector2 &p,int onpoint);
		
	void	addContour(int pointn);

	int	nPoints();
	int	isOnPoint(int n);
	Vector2	getPoint(int n);
	int	nContours();
	int	getContourStartPoint(int n);
	int	getContourEndPoint(int n);
	double	width();
	double	height();
	double	ascend();
	double	descend();
	double	space();
	void	setSpace(double);
};

#endif


