#ifndef KBLINSELWIDGET_H 
#define KBLINSELWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <qwidget.h>
#include <kfiledialog.h>
#include <qlabel.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qstring.h>
#include <kmsgbox.h>
#include <qprinter.h>
#include <qprintdialog.h>
#include <qpainter.h>
#include <qlistbox.h>
#include <qdir.h>
#include <kconfig.h>
#include <klined.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <drag.h>
#include <knewpanner.h>
#include <kimgio.h>

#include "deiminger.h"
#include "kblinselstereogram.h"
#include "kblinselconfig.h"

class KBlinselWidget : public QWidget
{
	Q_OBJECT
public:
	KBlinselWidget(QWidget *parent = 0, const char *name = 0);
	virtual ~KBlinselWidget();
	KBlinselStereogram algo;
        QPixmap pm;

public slots:
	void loadImg();
	void loadImg(QString *filename);
	void saveImg();
	void genStereo();
	void printImg();
	void configure();
	void togglePattern(bool flag);
	void scanPatternDir();
	void confReturn(bool flag);
	void slotDropEvent(KDNDDropZone *);
	void setPattern(int);

protected:
	void resizeEvent( QResizeEvent * );

signals:
	void pleasedraw();
private:
	KConfig *config;
	KBlinselConfig *configDlg;

	QLabel *labelImg;
	QImage img,img1;
	int loaded;
	QPainter *painter;
	QPrinter *printer;
	QPrintDialog *printdlg;
	QListBox *patternview;
	QDir *patternDir;
	KNewPanner *panner;

};

#endif // KBLINSELWIDGET_H 
