/*
 *   kscan - a scanning program
 *   Copyright (C) 1998 Ivan Shvedunov
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __BACKEND_H__
#define __BACKEND_H__

#include <qwidget.h>
#include <qapp.h>
#include <qpushbt.h>
#include <qdialog.h>
#include <stdlib.h>

#include "scan.h"
#include "kscan.h"

class BackendDialog: public QDialog {
	Q_OBJECT
public:
	BackendDialog(KConfig *kc,char *backend,
		      bool showWarning);
protected slots:
	void selected(int) { emit accept(); }
	void done(int);
private:
	QListBox *backends;
	KConfig *kconf;
	SANE_Device **dl;
	char *b;
	bool sw;
};

#endif
