/*
 *   kscan - a scanning program
 *   Copyright (C) 1998 Ivan Shvedunov
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __PREVIEW_H__
#define __PREVIEW_H__

#include <qwidget.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qcursor.h>
#include <qrect.h>
#include <stdlib.h>
#include <kapp.h>

#include "scan.h"

enum preview_state {
	MOVE_NONE,
	MOVE_TOP_LEFT,
	MOVE_TOP_RIGHT,
	MOVE_BOTTOM_LEFT,
	MOVE_BOTTOM_RIGHT,
	MOVE_LEFT,
	MOVE_RIGHT,
	MOVE_TOP,
	MOVE_BOTTOM,
	MOVE_WHOLE
};

enum cursor_type {
	CROSS,
	VSIZE,
	HSIZE,
	BDIAG,
	FDIAG,
	ALL,
	HREN
};

const int MIN_AREA_WIDTH = 3;
const int MIN_AREA_HEIGHT = 3;
const int delta = 3;
#ifdef __PREVIEW_CPP__
int max_dpi = 600;
#else
extern int max_dpi;
#endif

class Preview : public QWidget {
	Q_OBJECT
public:
	Preview(QWidget *parent = NULL, const char *name = NULL);
	double xInches();
	double yInches();
	int calculateDpi(int xw);
	void save(int dpi);
	void setType(scan_type t) {
		type = t;
		s_img->setType(type);
		if(acquired) acquire();
	}
	int getBrightness() { return brightness; }
	int getContrast() { return contrast; }
	int getGamma() { return gamma; }
	double xtomms(double x);
	double ytomms(double y);
	bool hasImage() { return acquired; }
	QRect *sel() { return selected; }
	QImage *image() { return s_img->image(); }
public slots:
        void setBrightness(int b)
	{ brightness = b; redraw(); emit changed(); }
	void setContrast(int c)
	{ contrast = c; redraw(); emit changed(); }
	void setGamma(int c)
	{ gamma = c; redraw(); emit changed(); }
	void redraw();
	void zoomOut();
	void zoomIn();
	void acquire();
signals:
	void changed();
	void noRect();
	void newRect();
	void sizeChanged();
protected:
	void paintEvent(QPaintEvent *);
	void timerEvent(QTimerEvent *);
	void mousePressEvent(QMouseEvent *);
	void mouseReleaseEvent(QMouseEvent *);
	void mouseMoveEvent(QMouseEvent *);
private:
	ScanImage *s_img;
	QPixmap *px;
	QRect *selected;
	int gamma,brightness,contrast;
	preview_state moving;
	int cr1,cr2;
	int lx,ly;
	scan_type type;
	bool zoomed,acquired;
	double xmms,ymms,xmms_cur,ymms_cur,x_offs,y_offs;
	void drawHAreaBorder(QPainter &p,int x1,int x2,int y,int r = FALSE);
	void drawVAreaBorder(QPainter &p,int x,int y1,int y2,int r = FALSE);
	void drawAreaBorder(QPainter *p,int r = FALSE);
	preview_state classifyPoint(int x,int y);
};

#endif
