/*
 *   kscan - a scanning program
 *   Copyright (C) 1998 Ivan Shvedunov
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qimage.h>
extern "C" {
#include <sane.h>
}
#include <stdio.h>
#include <math.h>
#include <kapp.h>
#include "scan.h"

SANE_Int options[NUMREQ];
SANE_Handle h;

char *required_options[NUMREQ] = {
	"mode",
	"brightness",
	"contrast",
	"resolution",
	"tl-x",
	"tl-y",
	"br-x",
	"br-y"
};

bool ScanImage::find_options()
{
	SANE_Int n;
	const SANE_Option_Descriptor *d;
	printf("find_options()\n");
	sane_control_option(h,0,SANE_ACTION_GET_VALUE,&n,NULL);
	memset(options,0,sizeof(SANE_Int)*NUMREQ);
	for(int i = 1; i<n; i++) {
		d = sane_get_option_descriptor(h,i);
		if(!d) break;
		if(!d->name) continue;
		for(int j = 0; j<NUMREQ; j++)
			if(!strcmp(d->name,required_options[j]))
				options[j] = i;
	}
	for(int i = 0; i<NUMREQ; i++)
		if(!options[i]) {
			printf("Incomplete options\n");
			sane_close(h);
			//sane_exit();
			return FALSE;
		}
	return TRUE;
}

SANE_Status ScanImage::set_option(int opt,void *val)
{
	return sane_control_option(h,options[opt],
				   SANE_ACTION_SET_VALUE,val,NULL);
}

void ScanImage::get_option(int opt,void *val)
{
	sane_control_option(h,options[opt],SANE_ACTION_GET_VALUE,val,NULL);
}

void ScanImage::set_auto(int opt)
{
	sane_control_option(h,options[opt],SANE_ACTION_SET_AUTO,NULL,NULL);
}

void ScanImage::receive()
{
	int len;
	if(sane_read(h,dat,1000,&len) == SANE_STATUS_EOF) {
		done++;
		return;
	}
	dat += len;
	dlg->setProgress(dlg->progress()+len);
}

int ScanImage::acquire()
{
	setMode(type==GRAY?"Gray":"Color");
	sane_start(h);
	sane_get_parameters(h,&p);
	
	printf("format : %d\nlast_frame : %d\nlines : %d\ndepth : %d\n"
	       "pixels_per_line : %d\nbytes_per_line : %d\n",
	       p.format,p.last_frame,p.lines,p.depth,p.pixels_per_line,
	       p.bytes_per_line);
	
	if(img) delete img;
	if(type==COLOR)
		img = new QImage(p.pixels_per_line,p.lines,32);
	else {
		img = new QImage(p.pixels_per_line,p.lines,8,256);
		for(int i = 0; i<256; i++)
			img->setColor(i,qRgb(i,i,i));
	}
	maxlen = p.bytes_per_line*p.lines;
	if(data) delete data;
	data = new SANE_Byte[maxlen];
	dlg = new QProgressDialog("Acquiring RGB data...",
				  "Cancel",
				  maxlen,NULL,NULL,TRUE);
	dlg->setProgress(0);
	dlg->show();
	kapp->processEvents();
	dat = data;
	done = 0;
	while(!done) {
		receive();
		kapp->processEvents();
	}
	delete dlg;
	sane_cancel(h);
	return TRUE;
}

inline int adjust(int x,int g,int b,int c)
{
	//printf("x : %d, x/256 : %lg, g : %d, 100/g : %lg",
	//       x,(double)x/256.0,g,100.0/(double)g);
	x = (int)(256*pow((double)x/256.0,100.0/(double)g));
        x = ((65536/(128-c)-256)*(x-128)>>8)+128+b;
	if(x<0) x = 0; else if(x>255) x = 255;
	//printf(" -> %d\n",x);
	return x;
}

void ScanImage::adjust_and_convert(int gamma = 100,int brightness = 0,
				   int contrast = 0)
{
	//Convert raw scanned data to QImage Gray/RGB data
	SANE_Byte *dt = data;
	int convtab[256];
	if(!gamma) gamma++;
	int count[256];
	//int eqtab[256];
	memset(count,0,256*sizeof(int));
	brightness = (brightness<<8)/(128-contrast);
	for(int i = 0; i<256; i++)
		convtab[i] = adjust(i,gamma,brightness,contrast);

	/*
	  for(int i = 0; i<maxlen; i += 3) {
	        int     r = convtab[*dt++],
	        g = convtab[*dt++],
	        b = convtab[*dt++];
		//QColor c(r,g,b);
		//int h,s,v;
		//c.hsv(&h,&s,&v);
		//if(!(i%2000)) printf("v = %d\n",v);
		count[(r+g+b)/3]++;
	}
	dt = data;
        int sum = 0;
	int step = maxlen/(3*256);
	*eqtab = 0;
	for(int i = 1; i<256; i++) {
		eqtab[i] = sum/step;
		sum += count[i];
		printf("sum = %d, count[%d] = %d, eqtab[%d] = %d\n",
		       sum,i,count[i],i,eqtab[i]);
	}
	*/

	printf("converting...\n");
	for(int i = 0; i<p.lines; i++) {
		uint *scanline = (uint *)img->scanLine(i);
		for(int j = 0; j<p.pixels_per_line; j++)
			if(type==COLOR) {
				int     r = convtab[*dt++],
					g = convtab[*dt++],
					b = convtab[*dt++];
				/*int I = (r+g+b)/3;
				  QColor c(r,g,b);
				  int h,s,v;
				  c.hsv(&h,&s,&v);
				  c.setHsv(h,s,eqtab[v]);
				  c.rgb(&r,&g,&b);*/
				//r = eqtab[r];
				//g = eqtab[g];
				//b = eqtab[b];
				scanline[j] = qRgb(r,g,b);
			} else ((unsigned char *)scanline)[j] = convtab[*dt++];
	}
	printf("done.\n");
}

bool ScanImage::InitScanner(char *backend)
{
	static int first_time = TRUE;
	printf("InitScanner()\n");
	if(first_time&&sane_init(NULL,NULL)) return FALSE;
	first_time = FALSE;
	if(sane_open(backend,&h)) {
		//sane_exit();
		return FALSE;
	}
	return find_options();
}

void ScanImage::CloseScanner()
{
	sane_close(h);
	sane_exit();
	exit(0);
}

#include "scan.moc"
