/*
 *   kscan - a scanning program
 *   Copyright (C) 1998 Ivan Shvedunov
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __SCAN_H__
#define __SCAN_H__

#include <qimage.h>
#include <qprogdlg.h>
#include <qobject.h>
#include <qsocknot.h>
extern "C" {
#include <sane/sane.h>
}
#include <stdio.h>

#define NUMREQ 8
// Scanner Options
#define MODE        0
#define BRIGHTNESS  1
#define CONTRAST    2
#define RESOLUTION  3
#define TLX         4
#define TLY         5
#define BRX         6
#define BRY         7

const double mms_per_inch = 25.39; //Am I right ?

enum scan_type { GRAY, COLOR};

class ScanImage : public QObject {
	Q_OBJECT
public:
	static int getDevices(const SANE_Device ***dl)
	{ return !sane_get_devices(dl,FALSE); }
	static bool InitScanner(char *backend); // Returns true on success
	static void CloseScanner();
	ScanImage(scan_type t):QObject(),img(NULL),data(NULL) {
		set_auto(TLX);
		set_auto(TLY);
		set_auto(BRX);
		set_auto(BRY);
		type = t;
		setMode(type==GRAY?"Gray":"Color");
	}
	~ScanImage() {
		printf("ScanImage: UNDER DESTRUCTION\n");
		if(img) delete img;
		if(data) delete data;
	}
	void setType(scan_type t) {
		type = t;
		setMode(type==GRAY?"Gray":"Color");
	}
	QImage *image() { return img; }
	int getResolution()
	{ int tmp; get_option(RESOLUTION,&tmp); return tmp; }
	void getArea(SANE_Fixed &tlx,SANE_Fixed &tly,
		      SANE_Fixed &brx,SANE_Fixed &bry) {
		get_option(TLX,&tlx); get_option(TLY,&tly);
		get_option(BRX,&brx); get_option(BRY,&bry);
	}
	int acquire();
	void adjust_and_convert(int gamma = 100,int brightness = 0,
				int contrast = 0);
public slots:
        void setMode(char *mode)
	{ set_option(MODE,mode); }
	void setBrightness(int brightness)
	{ set_option(BRIGHTNESS,&brightness); }
	void setContrast(int contrast)
	{ set_option(CONTRAST,&contrast); }
	void setResolution(int dpi)
	{ printf("setResolution(%d) = %d\n",dpi,set_option(RESOLUTION,&dpi)); }
	void setArea(SANE_Fixed tlx,SANE_Fixed tly,
		      SANE_Fixed brx,SANE_Fixed bry) {
		set_option(TLX,&tlx); set_option(TLY,&tly);
		set_option(BRX,&brx); set_option(BRY,&bry);
	}
	void receive();
private:
	SANE_Status set_option(int opt,void *val);
	void get_option(int opt,void *val);
	void set_auto(int opt);
	static bool find_options();
protected:
	QImage *img;
	QProgressDialog *dlg;
	//QSocketNotifier *sn;
	SANE_Byte *data,*dat;
	SANE_Parameters p;
	int maxlen,done;
	scan_type type;
};

#endif
