/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef CHILDREN
#define CHILDREN

// label
#define ChildrenLabel "Children"

// classes
#include <SFNode.h>
#include <SFVec3f.h>
#include <SFString.h>

// class definition
class Children : public SFNode {

 public:

  // constructor
  Children() : SFNode(ChildrenLabel) {
    privateNext = (Children *) 0;
    privateData = (SFNode   *) 0;
  }

  // destructor
  ~Children() {
    if (privateData != (SFNode   *) 0) delete privateData;
    if (privateNext != (Children *) 0) delete privateNext;
    privateNext = (Children *) 0;
    privateData = (SFNode   *) 0;
    
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render
  void render  (SFRenderInfo &);

  // operator
  Children &operator = (Children &C2) {
    data()           = C2.data();
    next()           = C2.next();
    isValid()        = C2.isValid();
    return(*this);
  }
  SFNode *operator [] (int i);

  // Queue
  void push(Children &, SFString &);

  // USE-DEF
  SFNode *findUSE();
  SFNode *findDEF(SFString &);
  SFString *use() {
    return(&USE);
  }

  // access
  Children* &next() {
    return(privateNext);
  }
  SFNode* &data() {
    return(privateData);
  }

  // modifies the list
  SFNode *add(SFNode *M);
  void remove(SFNode *M);

 protected:

 private:

  // data
  Children *privateNext;
  SFNode   *privateData;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // Children
