/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef COLOR
#define COLOR

// label
#define ColorLabel "Color"

// classes
#include <SFNode.h>
#include <MFColor.h>
#include <SFString.h>

// class definition
class Color : public SFNode {

 public:

  // constructor
  Color() : SFNode(ColorLabel) {
  }
  
  // destructor
  ~Color() {
  }

  // parse
  void parse   (char         *, istream      &);
    
  // events
  void eventIn (SFString     &, SFNode       *);

  // operators
  Color &operator = (Color &C2) {
    color         = C2.color;
    isValid()     = C2.isValid();
    return(*this);
  }
  SFColor  &operator [] (int i) {
    return(color[i]);
  }
  int num () {
    return(color.num());
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  MFColor color;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // Color
