/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef COLORINTERPOLATOR
#define COLORINTERPOLATOR

// label
#define ColorInterpolatorLabel "ColorInterpolator"

// classes
#include <SFNode.h>
#include <MFColor.h>
#include <MFFloat.h>
#include <SFString.h>

// class definition
class ColorInterpolator : public SFNode {

 public:

  // constructor
  ColorInterpolator() : SFNode(ColorInterpolatorLabel) {
  }
    
  // destructor
  ~ColorInterpolator() {
  }

  // parse
  void parse   (char *, istream &);

  // events
  void eventIn (SFString &, SFNode *);
  void eventOut(SFString &, SFNode *);

  // operators
  ColorInterpolator &operator = (ColorInterpolator &C2) {
    key                       = C2.key;
    keyValue                  = C2.keyValue;
    value_changed             = C2.value_changed;
    isValid()                 = C2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  MFFloat key;
  MFColor keyValue;

  // event data
  SFColor value_changed;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // ColorInterpolator

