/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef CYLINDER
#define CYLINDER

// label
#define CylinderLabel "Cylinder"

// classes
#include <SFNode.h>
#include <SFFloat.h>
#include <SFBool.h>
#include <SFString.h>

// class definition
class Cylinder : public SFNode {

public:

  // constructor
  Cylinder() : SFNode(CylinderLabel) {
    radius         = 1.0;
    height         = 2.0;
    side           = true;
    top            = true;
    bottom         = true;
  }

  // destructor
  ~Cylinder() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);
    
  // render
  void render  (SFRenderInfo &);

  // operators
  Cylinder &operator = (Cylinder &C2) {
    radius           = C2.radius;
    height           = C2.height;
    side             = C2.side;
    top              = C2.top;
    bottom           = C2.bottom;
    isValid()        = C2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

protected:

private:

  // data
  SFFloat  radius;
  SFFloat  height;
  SFBool   side;
  SFBool   top;
  SFBool   bottom;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // Cylinder
