/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef ELEVATIONGRID
#define ELEVATIONGRID

// label
#define ElevationGridLabel "ElevationGrid"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <SFFloat.h>
#include <SFInt32.h>
#include <Color.h>
#include <Normal.h>
#include <TextureCoordinate.h>
#include <Coordinate.h>
#include <MFInt32.h>
#include <MFFloat.h>

// class definition
class ElevationGrid : public SFNode {

public:

  // constructor
  ElevationGrid() : SFNode(ElevationGridLabel) {
    creaseAngle     = 0.0;
    ccw             = true;
    solid           = true;
    colorPerVertex  = true;
    normalPerVertex = true;
    xDimension      = 0;
    zDimension      = 0;
    xSpacing        = 0.0;
    zSpacing        = 0.0; 
  }

  // destructor
  ~ElevationGrid() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);
    
  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode *);

  // operators
  ElevationGrid &operator = (ElevationGrid &E2) {
    color                 = E2.color;
    height                = E2.height;
    texCoord              = E2.texCoord;
    colorPerVertex        = E2.colorPerVertex;
    normal                = E2.normal;
    normalPerVertex       = E2.normalPerVertex;
    creaseAngle           = E2.creaseAngle;
    ccw                   = E2.ccw;
    solid                 = E2.solid;
    xDimension            = E2.xDimension;
    zDimension            = E2.zDimension;
    xSpacing              = E2.xSpacing;
    zSpacing              = E2.zSpacing;
    isValid()             = E2.isValid;
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

protected:

private:

  // data
  MFFloat            height;
  Color              color;
  MFInt32            colorIndex;
  Normal             normal;
  MFInt32            normalIndex;
  TextureCoordinate  texCoord;
  SFInt32            xDimension;
  SFInt32            zDimension;
  SFFloat            xSpacing;
  SFFloat            zSpacing;
  SFFloat            creaseAngle;
  SFBool             ccw;
  SFBool             solid;
  SFBool             normalPerVertex;
  SFBool             colorPerVertex;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // ElevationGrid
