/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef PROXIMITYSENSOR
#define PROXIMITYSENSOR

// label
#define ProximitySensorLabel "ProximitySensor"

// classes
#include <SFNode.h>
#include <SFFloat.h>
#include <SFBool.h>
#include <SFTime.h>
#include <SFVec3f.h>
#include <SFRotation.h>

// class definition
class ProximitySensor : public SFNode {

 public:

  // constructor
  ProximitySensor() : SFNode(ProximitySensorLabel) {
    enabled               = false;
    size[0]               = 0.0;
    size[1]               = 0.0;
    size[2]               = 0.0;
    center[0]             = 0.0;
    center[1]             = 0.0;
    center[2]             = 0.0;
    isActive              = false;
  }
    
  // destructor
  ~ProximitySensor() {
  }

  // parse
  void parse   (char *, istream  &);

  // events
  void eventIn (SFString &, SFNode *);
  void eventOut(SFString &, SFNode *);

  // operators
  ProximitySensor &operator = (ProximitySensor &T2) {
    enabled                 = T2.enabled;
    size                    = T2.size;
    center                  = T2.center;
    isActive                = T2.isActive;
    position_changed        = T2.position_changed;
    orientation_changed     = T2.orientation_changed;
    enterTime               = T2.enterTime;
    exitTime                = T2.exitTime;
    isValid()               = T2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFBool     enabled;
  SFVec3f    size;
  SFVec3f    center;

  // event data
  SFBool     isActive;
  SFVec3f    position_changed;
  SFRotation orientation_changed;
  SFTime     enterTime;
  SFTime     exitTime;

  // USE-DEF
  SFString   DEF;
  SFString   USE;

};

#endif // ProximitySensor








