/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SFBOOL
#define SFBOOL

// label
#define SFBoolLabel "SFBool"

// classes
#include <SFNode.h>

// class definition
class SFBool : public SFNode {

 public:

  // constructor
  SFBool() : SFNode(SFBoolLabel) {
    data = false;
  }
  SFBool(bool n) : SFNode(SFBoolLabel) {
    data = n;
  }
  
  // destructor
  ~SFBool() {
  }

  // parse
  void parse(char *, istream &);
      
  // operators
  bool operator () () {
    return(data);
  }
  operator bool () {
    return(data);
  }
  friend bool operator == (SFBool &b1, bool b2) {
    return(b1() == b2);
  }
  friend bool operator != (SFBool &b1, bool b2) {
    return(b1() != b2);
  }
  SFBool &operator = (SFBool &b1) {
    data = b1.data;
    return(*this);
  }
  SFBool &operator = (bool b1) {
    data = b1;
    return(*this);
  }

 protected:


 private:

  // the data
  bool data;

};

#endif // SFBool


