/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SFFLOAT
#define SFFLOAT

// label
#define SFFloatLabel "SFFloat"

//classes 
#include <SFNode.h>

// class definition
class SFFloat : public SFNode {

 public:

  // constructor
  SFFloat() : SFNode(SFFloatLabel) {
    data = 0.0;
  }
  
  // destructor
  ~SFFloat() {
  }

  // parse
  void parse(char *, istream &);

  // operators
  float operator () () {
    return(data);
  }
  friend float operator == (SFFloat &b1, float b2) {
    return((b1() - b2) < 0.00001);
  }
  friend float operator != (SFFloat &b1, float b2) {
    return((b1() - b2) > 0.00001);
  }
  friend float operator >= (SFFloat &b1, SFFloat &b2) {
    return((float) b1 >=  (float) b2);
  }
  friend float operator > (SFFloat &b1, SFFloat &b2) {
    return((float) b1 >  (float) b2);
  }
  friend float operator < (SFFloat &b1, SFFloat &b2) {
    return((float) b1 <  (float) b2);
  }
  friend float operator <= (SFFloat &b1, SFFloat &b2) {
    return((float) b1 <=  (float) b2);
  }
  operator float () {
    return(data);
  }
  SFFloat &operator = (SFFloat &b1) {
    data = b1.data;
    return(*this);
  }
  SFFloat &operator = (float b1) {
    data = b1;
    return(*this);
  }
  SFFloat &operator += (float b1) {
    data += b1;
    return(*this);
  }
  SFFloat &operator *= (float b1) {
    data *= b1;
    return(*this);
  }
  SFFloat &operator /= (float b1) {
    data /= b1;
    return(*this);
  }
 
 protected:

 private:

  // data
  float data;

};

#endif // SFFloat
