/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SFROTATION
#define SFROTATION

// label
#define SFRotationLabel "SFRotation"

// classes
#include <SFNode.h>
#include <SFFloat.h>

// class definition
class SFRotation : public SFNode {

 public:

  // constructor
  SFRotation() : SFNode(SFRotationLabel) {
    data[0] = 0.0;
    data[1] = 0.0;
    data[2] = 1.0;
    data[3] = 0.0;
  }

  // destructor
  ~SFRotation() {
  }

  // parse
  void parse (char *, istream      &);

  // render
  void render(SFRenderInfo &);

  // operators
  SFFloat & operator [] (int i) {
    if ((i < 0) || (i >= 4)) {
      cerr << "\nError:\n";
      cerr << "\tOccurred in SFRotation::operator[]\n";
      cerr << "\tOut of array bounds access (" << i << ") of (4)\n";
      exit(0);
    }
    return(data[i]); 
  }
  SFRotation &operator = (SFRotation &b1) {
    data[0] = b1.data[0];
    data[1] = b1.data[1];
    data[2] = b1.data[2];
    data[3] = b1.data[3];
    return(*this);
  }

 protected:

 private:

  // data
  SFFloat data[4];

};

#endif // SFRotation


