/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SOUND
#define SOUND

// label
#define SoundLabel "Sound"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <SFUrl.h>
#include <SFVec3f.h>
#include <Source.h>

// class definition
class Sound : public SFNode {

 public:

  // constructor
  Sound() : SFNode(SoundLabel) {
    intensity    = 1.0;
    priority     = 0.0;
    location[0]  = 0.0;
    location[1]  = 0.0;
    location[2]  = 0.0;
    direction[0] = 0.0;
    direction[1] = 0.0;
    direction[2] = 1.0;
    minFront     = 1.0;
    maxFront     = 10.0;;
    minBack      = 1.0;
    maxBack      = 10.0;
    spatialize   = true;
  }
  
  // destructor
  ~Sound() {
  }

  // parse
  void parse   (char     *, istream  &);

  // events
  void eventIn (SFString &, SFNode *);

  // operators
  Sound &operator = (Sound &S2) {
    source        = S2.source;
    intensity     = S2.intensity;
    priority      = S2.priority;
    location      = S2.location;
    direction     = S2.direction;
    minFront      = S2.minFront;
    maxFront      = S2.maxFront;
    minBack       = S2.minBack;
    maxBack       = S2.maxBack;
    spatialize    = S2.spatialize;
    isValid()     = S2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    SFNode *MFN = (SFNode *) 0;
    if (UnsatUSE == DEF) {
      MFN = (SFNode *) this;
    } else {
      MFN = source.findDEF(UnsatUSE);
    }
    return(MFN);
  }
  SFNode *findUSE() {
    SFNode *MFN = (SFNode *) 0;
    if (unsatisfiedUSE) {
      MFN = (SFNode *) this;
    } else {
      MFN = source.findUSE();
    }
    return(MFN);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  Source   source;
  SFFloat  intensity;
  SFFloat  priority;
  SFVec3f  location;
  SFVec3f  direction;
  SFFloat  minFront;
  SFFloat  maxFront;
  SFFloat  minBack;
  SFFloat  maxBack;
  SFBool   spatialize;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // Sound

