/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SOURCE
#define SOURCE

// label
#define SourceLabel "Source"

// classes
#include <SFNode.h>
#include <AudioClip.h>
#include <MovieTexture.h>

// class definition
class Source : public SFNode {

 public:

  // constructor
  Source() : SFNode(SourceLabel) {
  }
  
  // destructor
  ~Source() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render
  void render  (SFRenderInfo &);

  // operators
  Source &operator = (Source &T2) {
    if (T2.audioClip.isValid) audioClip      = T2.audioClip;
    if (T2.movieTexture.isValid) movieTexture   = T2.movieTexture;
    isValid()      = T2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    SFNode *MFN = (SFNode *) 0;
    if (DEF == UnsatUSE) {
      MFN = (SFNode *) this;
    } else {
      MFN = audioClip.findDEF(UnsatUSE);
      if (MFN == (SFNode *) 0) {
	MFN = movieTexture.findDEF(UnsatUSE);
      }
    }
    return(MFN);
  }
  SFNode *findUSE() {
    SFNode *MFN = (SFNode *) 0;
    if (unsatisfiedUSE()) {
      MFN = (SFNode *) this;
    } else {
      MFN = audioClip.findUSE();
      if (MFN == (SFNode *) 0) {
	MFN = movieTexture.findUSE();
      }
    }
    return(MFN);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  AudioClip    audioClip;
  MovieTexture movieTexture;

  // USE-DEF
  SFString     DEF;
  SFString     USE;

};

#endif // Source




