/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SPHERE
#define SPHERE

// label
#define SphereLabel "Sphere"

// classes
#include <SFNode.h>
#include <SFFloat.h>
#include <SFString.h>

// class definition
class Sphere : public SFNode {

public:

  // constructor
  Sphere() : SFNode(SphereLabel) {
    radius   = 1.0;
  }

  // destructor
  ~Sphere() {
  }

  // parse
  void parse   (char *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render
  void render  (SFRenderInfo &);

  // operators
  Sphere &operator = (Sphere &S2) {
    radius         = S2.radius;
    isValid()      = isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

protected:

private:

  // data
  SFFloat        radius;

  // USE-DEF
  SFString       DEF;
  SFString       USE;

};

#endif // Sphere
