/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef TEXT
#define TEXT

// label
#define TextLabel "Text"

// classes
#include <SFNode.h>
#include <SFRenderInfo.h>
#include <SFFloat.h>
#include <MFFloat.h>
#include <MFString.h>
#include <FontStyle.h>

// class definition
class Text : public SFNode {

public:

  // constructor
  Text():SFNode(TextLabel) {
    maxExtent = 0.0;
  }

  // destructor
  ~Text() {
  }

  // parse
  void parse  (char         *, istream      &);

  // prepare
  void prepare(SFVec3f      &, SFVec3f &);

  // render
  void render (SFRenderInfo &);
  
  // events
  void eventIn (SFString    &, SFNode  *);

  // operators
  Text &operator = (Text &T2) {
    maxExtent    = T2.maxExtent;
    astring      = T2.astring;
    length       = T2.length;
    fontStyle    = T2.fontStyle;
    isValid()    = T2.isValid();
    return(*this);
  }
    
  // USE-DEF
  SFNode *findUSE() {
    if (unsatisfiedUSE()) return(this);
    return(fontStyle.findUSE());
  }
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return(fontStyle.findDEF(UnsatUSE));
  }
  SFString *use() {
    return(&USE);
  }

protected:

private:

  // data geometry
  MFString  astring;
  SFFloat   maxExtent;
  MFFloat   length;
  FontStyle fontStyle;

  // USE-DEF
  SFString  DEF;
  SFString  USE;

};

#endif // Text

