/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef TEXTURE
#define TEXTURE

// label
#define TextureLabel "Texture"

// classes
#include <SFNode.h>
#include <PixelTexture.h>
#include <ImageTexture.h>
#include <MovieTexture.h>

// class definition
class Texture : public SFNode {

 public:

  // constructor
  Texture() : SFNode(TextureLabel) {
  }
  
  // destructor
  ~Texture() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render
  void render  (SFRenderInfo &);

  // operators
  Texture &operator = (Texture &T2) {
    if (T2.imageTexture.isValid()) imageTexture = T2.imageTexture;
    if (T2.pixelTexture.isValid()) pixelTexture = T2.pixelTexture;
    if (T2.movieTexture.isValid()) movieTexture = T2.movieTexture;
    isValid()       = T2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    SFNode *MFN = (SFNode *) 0;
    if (DEF == UnsatUSE) {
      MFN = (SFNode *) this;
    } else {
      MFN = imageTexture.findDEF(UnsatUSE);
      if (MFN == (SFNode *) 0) {
	MFN = pixelTexture.findDEF(UnsatUSE);
	if (MFN == (SFNode *) 0) {
	  MFN = movieTexture.findDEF(UnsatUSE);
	}
      }
    }
    return(MFN);
  }
  SFNode *findUSE() {
    SFNode *MFN = (SFNode *) 0;
    if (unsatisfiedUSE()) {
      MFN = (SFNode *) this;
    } else {
      MFN = imageTexture.findUSE();
      if (MFN == (SFNode *) 0) {
	MFN = pixelTexture.findUSE();
	if (MFN == (SFNode *) 0) {
	  MFN = movieTexture.findUSE();
	}
      }
    }
    return(MFN);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  ImageTexture imageTexture;
  PixelTexture pixelTexture;
  MovieTexture movieTexture;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // Texture




