/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef TIMESENSOR
#define TIMESENSOR

// label
#define TimeSensorLabel "TimeSensor"

// classes
#include <SFNode.h>
#include <SFTime.h>
#include <SFBool.h>
#include <SFFloat.h>

// class definition
class TimeSensor : public SFNode {

 public:

  // constructor
  TimeSensor() : SFNode(TimeSensorLabel) {
    cycleInterval   = 1.0;
    loop            = false;
    startTime       = 0.0;
    stopTime        = 0.0;
    enabled         = true; 
    isActive        = false;
  }
    
  // destructor
  ~TimeSensor() {
  }

  // parse
  void parse   (char *, istream  &);

  // events
  void eventIn (SFString &, SFNode *);
  void eventOut(SFString &, SFNode *);

  // operators
  TimeSensor &operator = (TimeSensor &T2) {
    enabled            = T2.enabled;
    isActive           = T2.isActive;
    isValid()          = T2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFTime    cycleInterval;
  SFBool    loop;
  SFTime    startTime;
  SFTime    stopTime;
  SFBool    enabled;

  // event data
  SFTime    time;
  SFTime    cycleTime;
  SFFloat   fractionChanged;
  SFBool    isActive;

  // USE-DEF
  SFString   DEF;
  SFString   USE;

};

#endif // TimeSensor




