/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <MFVec2f.h>

/*************************************************************************/
void MFVec2f::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* a token in the file */
  SFToken Token;

  /* Scan until the beginning brace is found */
  streampos s = InFile.tellg();
  while ((Token != "[") && (Token.isSFFloat() == false) && (! InFile.eof())) {
    s = Token.GetToken(InFile);
  }

#ifdef DEBUG_PARSE_LOWEST
  cout << "\tMFVec2f: (" << Token() << ")\n";
#endif

  /* special case of only one float */
  if (Token != "[") {
    alloc(1);
    data[0].parse(header, InFile.seekg(s));
    return;
  }

  /* a temporary pointer to use for reading individual elements */
  SFVec2f tmp;

  /* we need to take two passes through the data, the first to count,
  ** the second to store. */
  s = InFile.tellg();
  for (int pass = 0; pass < 2; pass++) {

    /* restore the starting point */
    InFile.seekg(s);

    /* either allocate or zero out */
    if      (pass == 0) numElements = 0;
    else if (pass == 1) alloc(numElements);

    /* the current element */
    int CurNum = 0;

    /* commence to search for the matching bracket */
    strcpy(Token(), "\0");
    while ((Token != "]") && (! InFile.eof())) {

      /* Remember where the token started from */
      streampos p = Token.GetToken(InFile);
      
      /* based on what token was found, continue parsing */
      if (Token.isSFFloat()) {
	if (pass == 0) {
	  tmp.parse(header, InFile.seekg(p));
	  numElements += 1;
	} else {
	  data[CurNum].parse(header, InFile.seekg(p));
	  CurNum += 1;
	}
      }
    }
  }
}
/*************************************************************************/





