/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <SFString.h>
#include <SFEvent.h>
#include <PlaneSensor.h>
#include <Children.h>

/*************************************************************************/
void PlaneSensor::eventIn(SFString &eventType, SFNode *eventData)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered PlaneSensor::eventsIn (" << DEF << ")\n";
#endif 

  /* Determine what action to take based on incoming event */
  if ((eventType == "minPosition") || (eventType == "set_minPosition")) {
    SFVec2f *n = (SFVec2f *) eventData;
    minPosition = *n;

  } else if ((eventType == "maxPosition") || (eventType == "set_maxPosition")) {
    SFVec2f *n = (SFVec2f *) eventData;
    maxPosition = *n;

  } else if ((eventType == "enabled") || (eventType == "set_enabled")) {
    SFBool *n = (SFBool *) eventData;
    enabled = *n;

  } else if ((eventType == "offset") || (eventType == "set_ofset")) {
    SFVec3f *n = (SFVec3f *) eventData;
    offset = *n;

  } else if ((eventType == "autoOffset") || (eventType == "set_autoOffset")) {
    SFBool *n = (SFBool *) eventData;
    autoOffset = *n;

  }
}
/*************************************************************************/

/*************************************************************************/
void PlaneSensor::eventOut(SFString &, SFNode *)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered PlaneSensor::eventsOut (" << DEF << ")\n";
#endif 
  
}
/*************************************************************************/

/*************************************************************************/
void PlaneSensor::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* a token in the file */
  SFToken Token;

  /* the required labels */
  bool TokenFound  = false;
  bool BeginBracketFound   = false;

  /* commence to search for the matching bracket */
  while (! InFile.eof()) {
    
    /* Remember where the token started from */
    Token.GetToken(InFile);

#ifdef DEBUG_PARSE
    cout << "\tPlaneSensor: (" << Token() << ")\n";
#endif

    /* based on what token was found, continue parsing */
    if (Token == "DEF") {
      Token.GetToken(InFile);
      DEF = Token();

    } else if (Token == "USE") {
      Token.GetToken(InFile);
      USE = Token();
      unsatisfiedUSE() = true;
      return;

    } else if (Token == "minPosition") {
      minPosition.parse(header, InFile);

    } else if (Token == "maxPosition") {
      maxPosition.parse(header, InFile);

    } else if (Token == "enabled") {
      enabled.parse(header, InFile);

    } else if (Token == "offset") {
      offset.parse(header, InFile);

    } else if (Token == "autoOffset") {
      autoOffset.parse(header, InFile);

    } else if (Token == "PlaneSensor") {
      TokenFound = true;

    } else if (Token == "{") {
      BeginBracketFound = true;

    } else if (Token == "}") {
      break;
      
    } else {
      parseWarning(Token());

    }
  }

  /* if we did not find the material token we are in trouble */
  if (TokenFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected identifier token.\n";
    exit(0);
  }
  if (BeginBracketFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected \"{\" token.\n";
    exit(0);
  }
}
/*************************************************************************/

