/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <Anchor.h>
#include <SFToken.h>
#include <SFString.h>
#include <SFRotation.h>
#include <SFEvent.h>
#include <Children.h>

/* All the nodes in the VRML spec */
#include <Appearance.h>
#include <Anchor.h>
#include <AudioClip.h>
#include <Background.h>
#include <Billboard.h>
#include <Box.h>
#include <Collision.h>
#include <Color.h>
#include <ColorInterpolator.h>
#include <Cone.h>
#include <Coordinate.h>
#include <CoordinateInterpolator.h>
#include <Cylinder.h>
#include <CylinderSensor.h>
#include <DirectionalLight.h>
#include <ElevationGrid.h>
#include <Extrusion.h>
#include <Fog.h>
#include <FontStyle.h>
#include <Geometry.h>
#include <Group.h>
#include <ImageTexture.h>
#include <IndexedFaceSet.h>
#include <IndexedLineSet.h>
#include <Inline.h>
#include <Lod.h>
#include <Material.h>
#include <MovieTexture.h>
#include <NavigationInfo.h>
#include <Normal.h>
#include <NormalInterpolator.h>
#include <OrientationInterpolator.h>
#include <PixelTexture.h>
#include <PlaneSensor.h>
#include <PointLight.h>
#include <PointSet.h>
#include <PositionInterpolator.h>
#include <ProximitySensor.h>
#include <ScalarInterpolator.h>
#include <Script.h>
#include <Shape.h>
#include <Sound.h>
#include <Sphere.h>
#include <SphereSensor.h>
#include <SpotLight.h>
#include <Switch.h>
#include <Text.h>
#include <TextureCoordinate.h>
#include <TextureTransform.h>
#include <TimeSensor.h>
#include <TouchSensor.h>
#include <Transform.h>
#include <Viewpoint.h>
#include <VisibilitySensor.h>
#include <WorldInfo.h>
#include <SFString.h>


/*************************************************************************/
void SFNode::copy(SFNode *n)
{

  /* depending upon the type copy */
  if (strcmp(nodeType(), AppearanceLabel) == 0) {
    Appearance *a = (Appearance *) this;
    Appearance *b = (Appearance *) n;
    *a = *b;

  } else if (strcmp(nodeType(), AnchorLabel) == 0) {
    Anchor *a = (Anchor *) this;
    Anchor *b = (Anchor *) n;
    *a = *b;

  } else if (strcmp(nodeType(), AudioClipLabel) == 0) {
    AudioClip *a = (AudioClip *) this;
    AudioClip *b = (AudioClip *) n;
    *a = *b;

  } else if (strcmp(nodeType(), BackgroundLabel) == 0) {
    Background *a = (Background *) this;
    Background *b = (Background *) n;
    *a = *b;

  } else if (strcmp(nodeType(), BillboardLabel) == 0) {
    Billboard *a = (Billboard *) this;
    Billboard *b = (Billboard *) n;
    *a = *b;

  } else if (strcmp(nodeType(), BoxLabel) == 0) {
    Box *a = (Box *) this;
    Box *b = (Box *) n;
    *a = *b;

  } else if (strcmp(nodeType(), ChildrenLabel) == 0) {
    if (strcmp(n->nodeType(), ChildrenLabel) == 0) {
      Children *a = (Children *) this;
      Children *b = (Children *) n;
      *a = *b;
    } else {
      Children *a = (Children *) this;
      a->add(n);
    }

  } else if (strcmp(nodeType(), CollisionLabel) == 0) {
    Collision *a = (Collision *) this;
    Collision *b = (Collision *) n;
    *a = *b;

  } else if (strcmp(nodeType(), ColorLabel) == 0) {
    Color *a = (Color *) this;
    Color *b = (Color *) n;
    *a = *b;

  } else if (strcmp(nodeType(), ColorInterpolatorLabel) == 0) {
    ColorInterpolator *a = (ColorInterpolator *) this;
    ColorInterpolator *b = (ColorInterpolator *) n;
    *a = *b;

  } else if (strcmp(nodeType(), ConeLabel) == 0) {
    Cone *a = (Cone *) this;
    Cone *b = (Cone *) n;
    *a = *b;

  } else if (strcmp(nodeType(), CoordinateLabel) == 0) {
    Coordinate *a = (Coordinate *) this;
    Coordinate *b = (Coordinate *) n;
    *a = *b;

  } else if (strcmp(nodeType(), CoordinateInterpolatorLabel) == 0) {
    CoordinateInterpolator *a = (CoordinateInterpolator *) this;
    CoordinateInterpolator *b = (CoordinateInterpolator *) n;
    *a = *b;

  } else if (strcmp(nodeType(), CylinderLabel) == 0) {
    Cylinder *a = (Cylinder *) this;
    Cylinder *b = (Cylinder *) n;
    *a = *b;

  } else if (strcmp(nodeType(), CylinderSensorLabel) == 0) {
    CylinderSensor *a = (CylinderSensor *) this;
    CylinderSensor *b = (CylinderSensor *) n;
    *a = *b;

  } else if (strcmp(nodeType(), DirectionalLightLabel) == 0) {
    DirectionalLight *a = (DirectionalLight *) this;
    DirectionalLight *b = (DirectionalLight *) n;
    *a = *b;

  } else if (strcmp(nodeType(), ElevationGridLabel) == 0) {
    ElevationGrid *a = (ElevationGrid *) this;
    ElevationGrid *b = (ElevationGrid *) n;
    *a = *b;

  } else if (strcmp(nodeType(), ExtrusionLabel) == 0) {
    Extrusion *a = (Extrusion *) this;
    Extrusion *b = (Extrusion *) n;
    *a = *b;

  } else if (strcmp(nodeType(), FogLabel) == 0) {
    Fog *a = (Fog *) this;
    Fog *b = (Fog *) n;
    *a = *b;

  } else if (strcmp(nodeType(), FontStyleLabel) == 0) {
    FontStyle *a = (FontStyle *) this;
    FontStyle *b = (FontStyle *) n;
    *a = *b;

  } else if (strcmp(nodeType(), GeometryLabel) == 0) {
    Geometry *a = (Geometry *) this;
    Geometry *b = (Geometry *) n;
    *a = *b;

  } else if (strcmp(nodeType(), GroupLabel) == 0) {
    Group *a = (Group *) this;
    Group *b = (Group *) n;
    *a = *b;

  } else if (strcmp(nodeType(), ImageTextureLabel) == 0) {
    ImageTexture *a = (ImageTexture *) this;
    ImageTexture *b = (ImageTexture *) n;
    *a = *b;

  } else if (strcmp(nodeType(), IndexedFaceSetLabel) == 0) {
    IndexedFaceSet *a = (IndexedFaceSet *) this;
    IndexedFaceSet *b = (IndexedFaceSet *) n;
    *a = *b;

  } else if (strcmp(nodeType(), IndexedLineSetLabel) == 0) {
    IndexedLineSet *a = (IndexedLineSet *) this;
    IndexedLineSet *b = (IndexedLineSet *) n;
    *a = *b;

  } else if (strcmp(nodeType(), InlineLabel) == 0) {
    Inline *a = (Inline *) this;
    Inline *b = (Inline *) n;
    *a = *b;

  } else if (strcmp(nodeType(), LodLabel) == 0) {
    Lod *a = (Lod *) this;
    Lod *b = (Lod *) n;
    *a = *b;

  } else if (strcmp(nodeType(), MaterialLabel) == 0) {
    Material *a = (Material *) this;
    Material *b = (Material *) n;
    *a = *b;

  } else if (strcmp(nodeType(), MovieTextureLabel) == 0) {
    MovieTexture *a = (MovieTexture *) this;
    MovieTexture *b = (MovieTexture *) n;
    *a = *b;

  } else if (strcmp(nodeType(), NavigationInfoLabel) == 0) {
    NavigationInfo *a = (NavigationInfo *) this;
    NavigationInfo *b = (NavigationInfo *) n;
    *a = *b;

  } else if (strcmp(nodeType(), NormalLabel) == 0) {
    Normal *a = (Normal *) this;
    Normal *b = (Normal *) n;
    *a = *b;

  } else if (strcmp(nodeType(), NormalInterpolatorLabel) == 0) {
    NormalInterpolator *a = (NormalInterpolator *) this;
    NormalInterpolator *b = (NormalInterpolator *) n;
    *a = *b;

  } else if (strcmp(nodeType(), OrientationInterpolatorLabel) == 0) {
    OrientationInterpolator *a = (OrientationInterpolator *) this;
    OrientationInterpolator *b = (OrientationInterpolator *) n;
    *a = *b;

  } else if (strcmp(nodeType(), PixelTextureLabel) == 0) {
    PixelTexture *a = (PixelTexture *) this;
    PixelTexture *b = (PixelTexture *) n;
    *a = *b;

  } else if (strcmp(nodeType(), PlaneSensorLabel) == 0) {
    PlaneSensor *a = (PlaneSensor *) this;
    PlaneSensor *b = (PlaneSensor *) n;
    *a = *b;

  } else if (strcmp(nodeType(), PointLightLabel) == 0) {
    PointLight *a = (PointLight *) this;
    PointLight *b = (PointLight *) n;
    *a = *b;

  } else if (strcmp(nodeType(), PointSetLabel) == 0) {
    PointSet *a = (PointSet *) this;
    PointSet *b = (PointSet *) n;
    *a = *b;

  } else if (strcmp(nodeType(), PositionInterpolatorLabel) == 0) {
    PositionInterpolator *a = (PositionInterpolator *) this;
    PositionInterpolator *b = (PositionInterpolator *) n;
    *a = *b;

  } else if (strcmp(nodeType(), ProximitySensorLabel) == 0) {
    ProximitySensor *a = (ProximitySensor *) this;
    ProximitySensor *b = (ProximitySensor *) n;
    *a = *b;

  } else if (strcmp(nodeType(), ScalarInterpolatorLabel) == 0) {
    ScalarInterpolator *a = (ScalarInterpolator *) this;
    ScalarInterpolator *b = (ScalarInterpolator *) n;
    *a = *b;

  } else if (strcmp(nodeType(), ScriptLabel) == 0) {
    Script *a = (Script *) this;
    Script *b = (Script *) n;
    *a = *b;

  } else if (strcmp(nodeType(), ShapeLabel) == 0) {
    Shape *a = (Shape *) this;
    Shape *b = (Shape *) n;
    *a = *b;

  } else if (strcmp(nodeType(), SoundLabel) == 0) {
    Sound *a = (Sound *) this;
     Sound*b = (Sound *) n;
    *a = *b;

  } else if (strcmp(nodeType(), SphereLabel) == 0) {
     Sphere *a = (Sphere *) this;
     Sphere *b = (Sphere *) n;
     *a = *b;

  } else if (strcmp(nodeType(), SphereSensorLabel) == 0) {
    SphereSensor *a = (SphereSensor *) this;
    SphereSensor *b = (SphereSensor *) n;
    *a = *b;

  } else if (strcmp(nodeType(), SpotLightLabel) == 0) {
     SpotLight *a = (SpotLight *) this;
     SpotLight *b = (SpotLight *) n;
     *a = *b;

  } else if (strcmp(nodeType(), SwitchLabel) == 0) {
    Switch *a = (Switch *) this;
    Switch *b = (Switch *) n;
    *a = *b;

  } else if (strcmp(nodeType(), TextLabel) == 0) {
    Text *a = (Text *) this;
    Text *b = (Text *) n;
    *a = *b;

  } else if (strcmp(nodeType(), TextureCoordinateLabel) == 0) {
    TextureCoordinate *a = (TextureCoordinate *) this;
    TextureCoordinate *b = (TextureCoordinate *) n;
    *a = *b;

  } else if (strcmp(nodeType(), TextureLabel) == 0) {
    Texture *a = (Texture *) this;
    Texture *b = (Texture *) n;
    *a = *b;
    
  } else if (strcmp(nodeType(), TextureTransformLabel) == 0) {
    TextureTransform *a = (TextureTransform *) this;
    TextureTransform *b = (TextureTransform *) n;
    *a = *b;
    
  } else if (strcmp(nodeType(), TimeSensorLabel) == 0) {
    TimeSensor *a = (TimeSensor *) this;
    TimeSensor *b = (TimeSensor *) n;
    *a = *b;

  } else if (strcmp(nodeType(), TouchSensorLabel) == 0) {
    TouchSensor *a = (TouchSensor *) this;
    TouchSensor *b = (TouchSensor *) n;
    *a = *b;

  } else if (strcmp(nodeType(), TransformLabel) == 0) {
    Transform *a = (Transform *) this;
    Transform *b = (Transform *) n;
    *a = *b;

  } else if (strcmp(nodeType(), ViewpointLabel) == 0) {
    Viewpoint *a = (Viewpoint *) this;
    Viewpoint *b = (Viewpoint *) n;
    *a = *b;

  } else if (strcmp(nodeType(), VisibilitySensorLabel) == 0) {
    VisibilitySensor *a = (VisibilitySensor *) this;
    VisibilitySensor *b = (VisibilitySensor *) n;
    *a = *b;

  } else if (strcmp(nodeType(), WorldInfoLabel) == 0) {
    WorldInfo *a = (WorldInfo *) this;
    WorldInfo *b = (WorldInfo *) n;
    *a = *b;

  } else {
    cerr << "\nError:\n";
    cerr << "\tOccurred in SFNode::Copy()\n";
    cerr << "\tNo Copy for (" << nodeType() << ")\n";
    cerr << "\tUSE: (" << *(use()) << ")\n";
    cerr << "\tUSE: (" << *(n->use()) << ")\n";
    exit(0);
  }

}
/*************************************************************************/

/*************************************************************************/
void SFNode::addEvent(SFEvent *n)
{

  /* determine if already a list availiable */
  if (eventQueue() == (Children *) 0)  eventQueue() = new Children;

  /* add event */
  eventQueue()->add(n);

}
/*************************************************************************/

/*************************************************************************/
void SFNode::push(Children &stack, SFString &stackType) 
{

  /* if the correct type add to the queue */
  if (stackType == nodeType()) stack.add(this); 

}
/*************************************************************************/

