#!/usr/bin/perl

$INITIAL_STATE= 0;
$IN_CLASS_STATE= 1;
#$IN_SIGNALS_STATE= 2;
#$IN_SLOTS_STATE= 3;

$state= $INITAL_STATE;
$protection= "initial";

sub parseMethod {
#  warn "Found a method, protection is $protection\n";

  ($name)= /(\w+)\(/;

  /\s*(.*?)$name\s*\(/;
  $return= $1;

  /$name\s*\((.*?)\)/;
  $args= $1;

  if ($return =~ /\bvoid\b/) {
    print "Name: $name";
    print "\t\t";
    print "Args: $args";
    print "\t\t";
    print "Returns: $return\n";
  }
}

sub parseClass {
  # Remove Qt weirdness
  s/Q_EXPORT//;

  ($classname, $prot, $baseclass)= /\bclass\s+(\w+)\s*:\s*(public|private|protected)?\s*(\w+)/;
  print "Found $classname with base $baseclass ($prot)\n";

  while(<>) {
    if (/};/) {
      last;
    }
    elsif (/\b\w+\s+\w+\s*\(/) {
      if ($protection ne "private") {
	parseMethod();
      }
    }
    elsif (/\bpublic\s*?(\s+slots)?\s*:/) {
      $protection= "public";
    }
    elsif (/\bprivate\s*?(\s+slots)?\s*:/) {
      $protection= "private";
    }
    elsif (/\bprotected\s*?(\s+slots)?\s*:/) {
      $protection= "protected";
    }
  }
};


#
# main loop
#
while(<>) {
  # Forward declaration
  if (/\bclass\s+\w+\s*;/) {
    # Ignore them
  }
  elsif (/\bclass\s+\w+\s*/) {
    warn "Found a class\n";
    $state= $IN_CLASS_STATE;
    parseClass();
    $state= $INITIAL_STATE;
    warn "Left the class\n";
  }
}
