/***************************************************************************
                          boolvalueeditor.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Apr 10 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qlayout.h>
#include "boolvalueeditor.h"
#include "boolvalue.h"

BoolValueEditor::BoolValueEditor(QWidget *parent, const char *name, BoolValue *v )
	: ValueEditor(parent,name)
{
	setValue(v);
	
	checkBox= new QCheckBox(this);
	CHECK_PTR(checkBox);

	QHBoxLayout *layout= new QHBoxLayout(this);
	layout->addWidget(checkBox);
	layout->activate();

	connect(checkBox, SIGNAL(toggled(bool)), SLOT(checkToggled(bool)));
	checkBox->setChecked(v->boolValue());
	checkToggled(v->boolValue());
	checkBox->setFocus();
}

BoolValueEditor::~BoolValueEditor()
{
}

void BoolValueEditor::saveValue()
{
	bool b= checkBox->isChecked();

	BoolValue *bv= (BoolValue *) value();
	bv->setValue(b);
}

void BoolValueEditor::checkToggled(bool b)
{
	if (b)
		checkBox->setText("True");
	else
		checkBox->setText("False");
}




