/***************************************************************************
                          componentmanager.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 18 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef COMPONENTMANAGER_H
#define COMPONENTMANAGER_H

#include <qobject.h>
#include <qpopupmenu.h>
#include "component.h"
#include "package.h"

/**
 * Manages all the available components so they can be viewed in the component
 * pallete and created.
 *
 * @author Richard Moore
 */
class ComponentManager : public QObject  {
	Q_OBJECT

public:
	/**
	 * Create a ComponentManager.
	 */
	ComponentManager();
	~ComponentManager();

	/**
	 * Register a new Package of Components with the manager.
	 */
	void addPackage(Package *);
	uint packageCount();
	Package *package(uint n);

	/**
		* Returns the component with the id. The id is as used by the insert popup,
		* and the method returns 0 if no component with the id was found.
		*/
	Component *component(int);

	/**
		* Returns the package with the id or 0.
		*/
	Package *packageFromId(int id);
	
	/**
		* Create a popup menu of the available Packages and Components. The component
		* refered to by a menu item can be found by calling the component(int) method
		* passing the id of the menu item as the parameter.
		*/
	QPopupMenu *createInsertPopup(QPopupMenu *parent= 0);
	
	/**
		* Register the packages.
		*/
	void registerPackages();

protected:
	QList <Package> packages;
};

#endif
















